'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-40efc276.js');
const iconLibraryRegistry = require('./icon-library-registry-6662156a.js');

const iconLibraryCss = ":host{display:none}";

const IconLibrary = class {
  constructor(hostRef) {
    index.registerInstance(this, hostRef);
  }
  handleUpdate() {
    // Subsequent registrations with the same name will invalidate existing ones
    this.register();
  }
  connectedCallback() {
    if (this.name && this.resolver) {
      this.register();
    }
  }
  disconnectedCallback() {
    iconLibraryRegistry.unregisterLibrary(this.name);
  }
  register() {
    const { name, resolver, mutator } = this;
    iconLibraryRegistry.registerLibrary(name, resolver, mutator);
  }
  render() {
    return null;
  }
  static get watchers() { return {
    "name": ["handleUpdate"],
    "resolver": ["handleUpdate"],
    "mutator": ["handleUpdate"]
  }; }
};
IconLibrary.style = iconLibraryCss;

exports.sl_icon_library = IconLibrary;
