'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-40efc276.js');

const includeFiles = new Map();
const requestInclude = async (src, mode = 'cors') => {
  if (includeFiles.has(src)) {
    return includeFiles.get(src);
  }
  else {
    const request = fetch(src, { mode: mode }).then(async (response) => {
      return {
        ok: response.ok,
        status: response.status,
        html: await response.text()
      };
    });
    includeFiles.set(src, request);
    return request;
  }
};

const includeCss = ":host{display:block}";

const Include = class {
  constructor(hostRef) {
    index.registerInstance(this, hostRef);
    this.slLoad = index.createEvent(this, "sl-load", 7);
    this.slError = index.createEvent(this, "sl-error", 7);
    this.html = '';
    /** The fetch mode to use. */
    this.mode = 'cors';
    /**
     * Allows included scripts to be executed. You must ensure the content you're including is trusted, otherwise this
     * option can lead to XSS vulnerabilities in your app!
     */
    this.allowScripts = false;
  }
  handleSrcChange() {
    this.loadSource();
  }
  componentWillLoad() {
    this.loadSource();
  }
  executeScript(script) {
    // Create a copy of the script and swap it out so the browser executes it
    const newScript = document.createElement('script');
    [...script.attributes].map(attr => newScript.setAttribute(attr.name, attr.value));
    newScript.textContent = script.textContent;
    script.parentNode.replaceChild(newScript, script);
  }
  async loadSource() {
    try {
      const src = this.src;
      const file = await requestInclude(src, this.mode);
      // If the src changed since the request started do nothing, otherwise we risk overwriting a subsequent response
      if (src !== this.src) {
        return;
      }
      if (!file.ok) {
        this.slError.emit({ status: file.status });
        return;
      }
      this.host.innerHTML = file.html;
      if (this.allowScripts) {
        [...this.host.querySelectorAll('script')].map(script => this.executeScript(script));
      }
      this.slLoad.emit();
    }
    catch (_a) {
      this.slError.emit();
    }
  }
  render() {
    return index.h("slot", null);
  }
  get host() { return index.getElement(this); }
  static get watchers() { return {
    "src": ["handleSrcChange"]
  }; }
};
Include.style = includeCss;

exports.sl_include = Include;
