'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const index = require('./index-40efc276.js');

const menuItemCss = ":host{position:relative;box-sizing:border-box}:host *,:host *:before,:host *:after{box-sizing:inherit}:host{display:block}.menu-item{position:relative;display:flex;align-items:stretch;font-family:var(--sl-font-sans);font-size:var(--sl-font-size-medium);font-weight:var(--sl-font-weight-normal);line-height:var(--sl-line-height-normal);letter-spacing:var(--sl-letter-spacing-normal);text-align:left;color:var(--sl-color-gray-700);border-radius:var(--sl-border-radius-medium);padding:var(--sl-spacing-xx-small) var(--sl-spacing-x-large);transition:var(--sl-transition-fast) fill;user-select:none;white-space:nowrap;cursor:pointer;margin:0 var(--sl-spacing-x-small)}.menu-item.menu-item--focused:not(.menu-item--disabled){outline:none;background-color:var(--sl-color-primary-500);color:var(--sl-color-white)}.menu-item.menu-item--disabled{outline:none;color:var(--sl-color-gray-400);cursor:not-allowed}.menu-item .menu-item__label{flex:1 1 auto}.menu-item .menu-item__prefix{flex:0 0 auto;display:flex;align-items:center}.menu-item .menu-item__prefix ::slotted(:last-child){margin-right:0.5em}.menu-item .menu-item__suffix{flex:0 0 auto;display:flex;align-items:center}.menu-item .menu-item__suffix ::slotted(:first-child){margin-left:0.5em}.menu-item .menu-item__check{display:flex;position:absolute;left:0.5em;top:calc(50% - 0.5em);visibility:hidden;align-items:center;font-size:inherit}.menu-item--checked .menu-item__check{visibility:visible}";

const MenuItem = class {
  constructor(hostRef) {
    index.registerInstance(this, hostRef);
    this.hasFocus = false;
    /** Set to true to draw the item in a checked state. */
    this.checked = false;
    /** A unique value to store in the menu item. This can be used as a way to identify menu items when selected. */
    this.value = '';
    /** Set to true to draw the menu item in a disabled state. */
    this.disabled = false;
  }
  connectedCallback() {
    this.handleBlur = this.handleBlur.bind(this);
    this.handleFocus = this.handleFocus.bind(this);
    this.handleMouseEnter = this.handleMouseEnter.bind(this);
    this.handleMouseLeave = this.handleMouseLeave.bind(this);
  }
  /** Sets focus on the button. */
  async setFocus(options) {
    this.menuItem.focus(options);
  }
  /** Removes focus from the button. */
  async removeFocus() {
    this.menuItem.blur();
  }
  handleBlur() {
    this.hasFocus = false;
  }
  handleFocus() {
    this.hasFocus = true;
  }
  handleMouseEnter() {
    this.setFocus();
  }
  handleMouseLeave() {
    this.removeFocus();
  }
  render() {
    return (index.h("div", { ref: el => (this.menuItem = el), part: "base", class: {
        'menu-item': true,
        'menu-item--checked': this.checked,
        'menu-item--disabled': this.disabled,
        'menu-item--focused': this.hasFocus
      }, role: "menuitem", "aria-disabled": this.disabled ? 'true' : 'false', "aria-checked": this.checked ? 'true' : 'false', tabIndex: !this.disabled ? 0 : null, onFocus: this.handleFocus, onBlur: this.handleBlur, onMouseEnter: this.handleMouseEnter, onMouseLeave: this.handleMouseLeave }, index.h("span", { part: "checked-icon", class: "menu-item__check" }, index.h("sl-icon", { name: "check2", "aria-hidden": "true" })), index.h("span", { part: "prefix", class: "menu-item__prefix" }, index.h("slot", { name: "prefix" })), index.h("span", { part: "label", class: "menu-item__label" }, index.h("slot", null)), index.h("span", { part: "suffix", class: "menu-item__suffix" }, index.h("slot", { name: "suffix" }))));
  }
};
MenuItem.style = menuItemCss;

exports.sl_menu_item = MenuItem;
