import { Component, Method, Prop, State, h } from '@stencil/core';
/**
 * @since 2.0
 * @status stable
 *
 * @slot - The menu item's label.
 * @slot prefix - Used to prepend an icon or similar element to the menu item.
 * @slot suffix - Used to append an icon or similar element to the menu item.
 *
 * @part base - The component's base wrapper.
 * @part checked-icon - The container that wraps the checked icon.
 * @part prefix - The prefix container.
 * @part label - The menu item label.
 * @part suffix - The suffix container.
 */
export class MenuItem {
  constructor() {
    this.hasFocus = false;
    /** Set to true to draw the item in a checked state. */
    this.checked = false;
    /** A unique value to store in the menu item. This can be used as a way to identify menu items when selected. */
    this.value = '';
    /** Set to true to draw the menu item in a disabled state. */
    this.disabled = false;
  }
  connectedCallback() {
    this.handleBlur = this.handleBlur.bind(this);
    this.handleFocus = this.handleFocus.bind(this);
    this.handleMouseEnter = this.handleMouseEnter.bind(this);
    this.handleMouseLeave = this.handleMouseLeave.bind(this);
  }
  /** Sets focus on the button. */
  async setFocus(options) {
    this.menuItem.focus(options);
  }
  /** Removes focus from the button. */
  async removeFocus() {
    this.menuItem.blur();
  }
  handleBlur() {
    this.hasFocus = false;
  }
  handleFocus() {
    this.hasFocus = true;
  }
  handleMouseEnter() {
    this.setFocus();
  }
  handleMouseLeave() {
    this.removeFocus();
  }
  render() {
    return (h("div", { ref: el => (this.menuItem = el), part: "base", class: {
        'menu-item': true,
        'menu-item--checked': this.checked,
        'menu-item--disabled': this.disabled,
        'menu-item--focused': this.hasFocus
      }, role: "menuitem", "aria-disabled": this.disabled ? 'true' : 'false', "aria-checked": this.checked ? 'true' : 'false', tabIndex: !this.disabled ? 0 : null, onFocus: this.handleFocus, onBlur: this.handleBlur, onMouseEnter: this.handleMouseEnter, onMouseLeave: this.handleMouseLeave },
      h("span", { part: "checked-icon", class: "menu-item__check" },
        h("sl-icon", { name: "check2", "aria-hidden": "true" })),
      h("span", { part: "prefix", class: "menu-item__prefix" },
        h("slot", { name: "prefix" })),
      h("span", { part: "label", class: "menu-item__label" },
        h("slot", null)),
      h("span", { part: "suffix", class: "menu-item__suffix" },
        h("slot", { name: "suffix" }))));
  }
  static get is() { return "sl-menu-item"; }
  static get encapsulation() { return "shadow"; }
  static get originalStyleUrls() { return {
    "$": ["menu-item.scss"]
  }; }
  static get styleUrls() { return {
    "$": ["menu-item.css"]
  }; }
  static get properties() { return {
    "checked": {
      "type": "boolean",
      "mutable": false,
      "complexType": {
        "original": "boolean",
        "resolved": "boolean",
        "references": {}
      },
      "required": false,
      "optional": false,
      "docs": {
        "tags": [],
        "text": "Set to true to draw the item in a checked state."
      },
      "attribute": "checked",
      "reflect": true,
      "defaultValue": "false"
    },
    "value": {
      "type": "string",
      "mutable": false,
      "complexType": {
        "original": "string",
        "resolved": "string",
        "references": {}
      },
      "required": false,
      "optional": false,
      "docs": {
        "tags": [],
        "text": "A unique value to store in the menu item. This can be used as a way to identify menu items when selected."
      },
      "attribute": "value",
      "reflect": true,
      "defaultValue": "''"
    },
    "disabled": {
      "type": "boolean",
      "mutable": false,
      "complexType": {
        "original": "boolean",
        "resolved": "boolean",
        "references": {}
      },
      "required": false,
      "optional": false,
      "docs": {
        "tags": [],
        "text": "Set to true to draw the menu item in a disabled state."
      },
      "attribute": "disabled",
      "reflect": true,
      "defaultValue": "false"
    }
  }; }
  static get states() { return {
    "hasFocus": {}
  }; }
  static get methods() { return {
    "setFocus": {
      "complexType": {
        "signature": "(options?: FocusOptions) => Promise<void>",
        "parameters": [{
            "tags": [],
            "text": ""
          }],
        "references": {
          "Promise": {
            "location": "global"
          },
          "FocusOptions": {
            "location": "global"
          }
        },
        "return": "Promise<void>"
      },
      "docs": {
        "text": "Sets focus on the button.",
        "tags": []
      }
    },
    "removeFocus": {
      "complexType": {
        "signature": "() => Promise<void>",
        "parameters": [],
        "references": {
          "Promise": {
            "location": "global"
          }
        },
        "return": "Promise<void>"
      },
      "docs": {
        "text": "Removes focus from the button.",
        "tags": []
      }
    }
  }; }
}
