import { Component, Element, Event, h } from '@stencil/core';
/**
 * @since 2.0
 * @status experimental
 */
export class ResizeObserverUtility {
  constructor() {
    this.observedElements = [];
  }
  connectedCallback() {
    this.resizeObserver = new ResizeObserver(entries => this.slResize.emit(entries));
    this.handleSlotChange = this.handleSlotChange.bind(this);
  }
  disconnectedCallback() {
    this.resizeObserver.disconnect();
  }
  handleSlotChange() {
    const slot = this.host.shadowRoot.querySelector('slot');
    const elements = slot.assignedElements({ flatten: true });
    // Unwatch previous elements
    this.observedElements.map(el => this.resizeObserver.unobserve(el));
    this.observedElements = [];
    // Watch new elements
    elements.map(el => {
      this.resizeObserver.observe(el);
      this.observedElements.push(el);
    });
  }
  render() {
    return h("slot", { onSlotchange: this.handleSlotChange });
  }
  static get is() { return "sl-resize-observer"; }
  static get encapsulation() { return "shadow"; }
  static get originalStyleUrls() { return {
    "$": ["resize-observer.scss"]
  }; }
  static get styleUrls() { return {
    "$": ["resize-observer.css"]
  }; }
  static get events() { return [{
      "method": "slResize",
      "name": "sl-resize",
      "bubbles": true,
      "cancelable": true,
      "composed": true,
      "docs": {
        "tags": [],
        "text": "Emitted when the element is resized."
      },
      "complexType": {
        "original": "readonly ResizeObserverEntry[]",
        "resolved": "readonly ResizeObserverEntry[]",
        "references": {
          "ResizeObserverEntry": {
            "location": "global"
          }
        }
      }
    }]; }
  static get elementRef() { return "host"; }
}
