import { Component, Prop, Watch, h } from '@stencil/core';
/**
 * @since 2.0
 * @status stable
 *
 * @part base - The component's base wrapper.
 */
export class ResponsiveEmbed {
  constructor() {
    /**
     * The aspect ratio of the embedded media in the format of `width:height`, e.g. `16:9`, `4:3`, or `1:1`. Ratios not in
     * this format will be ignored.
     */
    this.aspectRatio = '16:9';
  }
  handleAspectRatioChange() {
    this.setAspectRatio();
  }
  connectedCallback() {
    this.handleSlotChange = this.handleSlotChange.bind(this);
  }
  handleSlotChange() {
    this.setAspectRatio();
  }
  setAspectRatio() {
    const split = this.aspectRatio.split(':');
    const x = parseInt(split[0]);
    const y = parseInt(split[1]);
    this.base.style.paddingBottom = x && y ? `${(y / x) * 100}%` : null;
  }
  render() {
    return (h("div", { ref: el => (this.base = el), part: "base", class: "responsive-embed" },
      h("slot", { onSlotchange: this.handleSlotChange })));
  }
  static get is() { return "sl-responsive-embed"; }
  static get encapsulation() { return "shadow"; }
  static get originalStyleUrls() { return {
    "$": ["responsive-embed.scss"]
  }; }
  static get styleUrls() { return {
    "$": ["responsive-embed.css"]
  }; }
  static get properties() { return {
    "aspectRatio": {
      "type": "string",
      "mutable": false,
      "complexType": {
        "original": "string",
        "resolved": "string",
        "references": {}
      },
      "required": false,
      "optional": false,
      "docs": {
        "tags": [],
        "text": "The aspect ratio of the embedded media in the format of `width:height`, e.g. `16:9`, `4:3`, or `1:1`. Ratios not in\nthis format will be ignored."
      },
      "attribute": "aspect-ratio",
      "reflect": false,
      "defaultValue": "'16:9'"
    }
  }; }
  static get watchers() { return [{
      "propName": "aspectRatio",
      "methodName": "handleAspectRatioChange"
    }]; }
}
