import { Component, Host, Prop, h } from '@stencil/core';
/**
 * @since 2.0
 * @status experimental
 */
export class Theme {
  constructor() {
    /**
     * The name of the theme to use. The user is responsible for including the associated stylesheet(s). Supportive themes
     * must adhere to theme guidelines by exposing a class that follows the `sl-theme-{name}` convention.
     */
    this.name = '';
  }
  render() {
    return (h(Host, { class: `sl-theme-${this.name}` },
      h("slot", null)));
  }
  static get is() { return "sl-theme"; }
  static get encapsulation() { return "shadow"; }
  static get originalStyleUrls() { return {
    "$": ["theme.scss"]
  }; }
  static get styleUrls() { return {
    "$": ["theme.css"]
  }; }
  static get properties() { return {
    "name": {
      "type": "string",
      "mutable": false,
      "complexType": {
        "original": "string",
        "resolved": "string",
        "references": {}
      },
      "required": false,
      "optional": false,
      "docs": {
        "tags": [],
        "text": "The name of the theme to use. The user is responsible for including the associated stylesheet(s). Supportive themes\nmust adhere to theme guidelines by exposing a class that follows the `sl-theme-{name}` convention."
      },
      "attribute": "name",
      "reflect": false,
      "defaultValue": "''"
    }
  }; }
}
