import { r as registerInstance, c as createEvent, h, g as getElement } from './index-9f8c8536.js';
import { h as hasSlot } from './slot-ff7446e5.js';
import { F as FormControl } from './form-control-4aacb3e8.js';

const buttonCss = ":host{position:relative;box-sizing:border-box}:host *,:host *:before,:host *:after{box-sizing:inherit}:host{display:inline-block;width:auto;cursor:pointer}.button{display:inline-flex;align-items:stretch;justify-content:center;width:100%;border-style:solid;border-width:var(--sl-input-border-width);font-family:var(--sl-input-font-family);font-weight:var(--sl-font-weight-semibold);text-decoration:none;user-select:none;white-space:nowrap;vertical-align:middle;padding:0;transition:var(--sl-transition-fast) background-color, var(--sl-transition-fast) color, var(--sl-transition-fast) border, var(--sl-transition-fast) box-shadow;cursor:inherit}.button::-moz-focus-inner{border:0}.button:focus{outline:none}.button.button--disabled{opacity:0.5;cursor:not-allowed}.button.button--disabled *{pointer-events:none}.button ::slotted(sl-icon){pointer-events:none}.button__prefix,.button__suffix{flex:0 0 auto;display:flex;align-items:center}.button__label ::slotted(sl-icon){vertical-align:-2px}.button.button--default{background-color:var(--sl-color-white);border-color:var(--sl-color-gray-300);color:var(--sl-color-gray-600)}.button.button--default:hover:not(.button--disabled){background-color:var(--sl-color-primary-50);border-color:var(--sl-color-primary-300);color:var(--sl-color-primary-600)}.button.button--default:focus:not(.button--disabled){background-color:var(--sl-color-primary-50);border-color:var(--sl-color-primary-300);color:var(--sl-color-primary-600);box-shadow:0 0 0 var(--sl-focus-ring-width) var(--sl-focus-ring-color-primary)}.button.button--default:active:not(.button--disabled){background-color:var(--sl-color-primary-100);border-color:var(--sl-color-primary-400);color:var(--sl-color-primary-700)}.button.button--primary{background-color:var(--sl-color-primary-500);border-color:var(--sl-color-primary-500);color:var(--sl-color-primary-text)}.button.button--primary:hover:not(.button--disabled){background-color:var(--sl-color-primary-400);border-color:var(--sl-color-primary-400);color:var(--sl-color-primary-text)}.button.button--primary:focus:not(.button--disabled){background-color:var(--sl-color-primary-400);border-color:var(--sl-color-primary-400);color:var(--sl-color-primary-text);box-shadow:0 0 0 var(--sl-focus-ring-width) var(--sl-focus-ring-color-primary)}.button.button--primary:active:not(.button--disabled){background-color:var(--sl-color-primary-500);border-color:var(--sl-color-primary-500);color:var(--sl-color-primary-text)}.button.button--success{background-color:var(--sl-color-success-500);border-color:var(--sl-color-success-500);color:var(--sl-color-success-text)}.button.button--success:hover:not(.button--disabled){background-color:var(--sl-color-success-400);border-color:var(--sl-color-success-400);color:var(--sl-color-success-text)}.button.button--success:focus:not(.button--disabled){background-color:var(--sl-color-success-400);border-color:var(--sl-color-success-400);color:var(--sl-color-success-text);box-shadow:0 0 0 var(--sl-focus-ring-width) var(--sl-focus-ring-color-success)}.button.button--success:active:not(.button--disabled){background-color:var(--sl-color-success-500);border-color:var(--sl-color-success-500);color:var(--sl-color-success-text)}.button.button--info{background-color:var(--sl-color-info-500);border-color:var(--sl-color-info-500);color:var(--sl-color-info-text)}.button.button--info:hover:not(.button--disabled){background-color:var(--sl-color-info-400);border-color:var(--sl-color-info-400);color:var(--sl-color-info-text)}.button.button--info:focus:not(.button--disabled){background-color:var(--sl-color-info-400);border-color:var(--sl-color-info-400);color:var(--sl-color-info-text);box-shadow:0 0 0 var(--sl-focus-ring-width) var(--sl-focus-ring-color-info)}.button.button--info:active:not(.button--disabled){background-color:var(--sl-color-info-500);border-color:var(--sl-color-info-500);color:var(--sl-color-info-text)}.button.button--warning{background-color:var(--sl-color-warning-500);border-color:var(--sl-color-warning-500);color:var(--sl-color-warning-text)}.button.button--warning:hover:not(.button--disabled){background-color:var(--sl-color-warning-400);border-color:var(--sl-color-warning-400);color:var(--sl-color-warning-text)}.button.button--warning:focus:not(.button--disabled){background-color:var(--sl-color-warning-400);border-color:var(--sl-color-warning-400);color:var(--sl-color-warning-text);box-shadow:0 0 0 var(--sl-focus-ring-width) var(--sl-focus-ring-color-warning)}.button.button--warning:active:not(.button--disabled){background-color:var(--sl-color-warning-500);border-color:var(--sl-color-warning-500);color:var(--sl-color-warning-text)}.button.button--danger{background-color:var(--sl-color-danger-500);border-color:var(--sl-color-danger-500);color:var(--sl-color-danger-text)}.button.button--danger:hover:not(.button--disabled){background-color:var(--sl-color-danger-400);border-color:var(--sl-color-danger-400);color:var(--sl-color-danger-text)}.button.button--danger:focus:not(.button--disabled){background-color:var(--sl-color-danger-400);border-color:var(--sl-color-danger-400);color:var(--sl-color-danger-text);box-shadow:0 0 0 var(--sl-focus-ring-width) var(--sl-focus-ring-color-danger)}.button.button--danger:active:not(.button--disabled){background-color:var(--sl-color-danger-500);border-color:var(--sl-color-danger-500);color:var(--sl-color-danger-text)}.button--text{background-color:transparent;border-color:transparent;color:var(--sl-color-primary-500)}.button--text:hover:not(.button--disabled){background-color:transparent;border-color:transparent;color:var(--sl-color-primary-400)}.button--text:focus:not(.button--disabled){background-color:transparent;border-color:transparent;color:var(--sl-color-primary-400);box-shadow:0 0 0 var(--sl-focus-ring-width) var(--sl-focus-ring-color-primary)}.button--text:active:not(.button--disabled){background-color:transparent;border-color:transparent;color:var(--sl-color-primary-600)}.button--small{font-size:var(--sl-button-font-size-small);height:var(--sl-input-height-small);line-height:calc(var(--sl-input-height-small) - var(--sl-input-border-width) * 2);border-radius:var(--sl-input-border-radius-small)}.button--medium{font-size:var(--sl-button-font-size-medium);height:var(--sl-input-height-medium);line-height:calc(var(--sl-input-height-medium) - var(--sl-input-border-width) * 2);border-radius:var(--sl-input-border-radius-medium)}.button--large{font-size:var(--sl-button-font-size-large);height:var(--sl-input-height-large);line-height:calc(var(--sl-input-height-large) - var(--sl-input-border-width) * 2);border-radius:var(--sl-input-border-radius-large)}.button--pill.button--small{border-radius:var(--sl-input-height-small)}.button--pill.button--medium{border-radius:var(--sl-input-height-medium)}.button--pill.button--large{border-radius:var(--sl-input-height-large)}.button--circle{padding-left:0;padding-right:0}.button--circle.button--small{width:var(--sl-input-height-small);border-radius:50%}.button--circle.button--medium{width:var(--sl-input-height-medium);border-radius:50%}.button--circle.button--large{width:var(--sl-input-height-large);border-radius:50%}.button--circle .button__prefix,.button--circle .button__suffix,.button--circle .button__caret{display:none}.button--caret .button__suffix{display:none}.button--caret .button__caret{display:flex;align-items:center}.button--caret .button__caret svg{width:1em;height:1em}.button--loading{position:relative;cursor:wait}.button--loading .button__prefix,.button--loading .button__label,.button--loading .button__suffix,.button--loading .button__caret{visibility:hidden}.button--loading sl-spinner{--indicator-color:currentColor;position:absolute;height:1em;width:1em;top:calc(50% - 0.5em);left:calc(50% - 0.5em)}.button ::slotted(sl-badge){position:absolute;top:0;right:0;transform:translateY(-50%) translateX(50%);pointer-events:none}.button--has-label.button--small .button__label{padding:0 var(--sl-spacing-small)}.button--has-label.button--medium .button__label{padding:0 var(--sl-spacing-medium)}.button--has-label.button--large .button__label{padding:0 var(--sl-spacing-large)}.button--has-prefix.button--small{padding-left:var(--sl-spacing-x-small)}.button--has-prefix.button--small .button__label{padding-left:var(--sl-spacing-x-small)}.button--has-prefix.button--medium{padding-left:var(--sl-spacing-small)}.button--has-prefix.button--medium .button__label{padding-left:var(--sl-spacing-small)}.button--has-prefix.button--large{padding-left:var(--sl-spacing-small)}.button--has-prefix.button--large .button__label{padding-left:var(--sl-spacing-small)}.button--has-suffix.button--small,.button--caret.button--small{padding-right:var(--sl-spacing-x-small)}.button--has-suffix.button--small .button__label,.button--caret.button--small .button__label{padding-right:var(--sl-spacing-x-small)}.button--has-suffix.button--medium,.button--caret.button--medium{padding-right:var(--sl-spacing-small)}.button--has-suffix.button--medium .button__label,.button--caret.button--medium .button__label{padding-right:var(--sl-spacing-small)}.button--has-suffix.button--large,.button--caret.button--large{padding-right:var(--sl-spacing-small)}.button--has-suffix.button--large .button__label,.button--caret.button--large .button__label{padding-right:var(--sl-spacing-small)}";

const Button = class {
  constructor(hostRef) {
    registerInstance(this, hostRef);
    this.slBlur = createEvent(this, "sl-blur", 7);
    this.slFocus = createEvent(this, "sl-focus", 7);
    this.hasFocus = false;
    this.hasLabel = false;
    this.hasPrefix = false;
    this.hasSuffix = false;
    /** The button's type. */
    this.type = 'default';
    /** The button's size. */
    this.size = 'medium';
    /** Set to true to draw the button with a caret for use with dropdowns, popovers, etc. */
    this.caret = false;
    /** Set to true to disable the button. */
    this.disabled = false;
    /** Set to true to draw the button in a loading state. */
    this.loading = false;
    /** Set to true to draw a pill-style button with rounded edges. */
    this.pill = false;
    /** Set to true to draw a circle button. */
    this.circle = false;
    /** Indicates if activating the button should submit the form. Ignored when `href` is set. */
    this.submit = false;
  }
  connectedCallback() {
    this.handleBlur = this.handleBlur.bind(this);
    this.handleFocus = this.handleFocus.bind(this);
    this.handleClick = this.handleClick.bind(this);
    this.handleSlotChange = this.handleSlotChange.bind(this);
  }
  componentWillLoad() {
    this.handleSlotChange();
  }
  /** Sets focus on the button. */
  async setFocus(options) {
    this.button.focus(options);
  }
  /** Removes focus from the button. */
  async removeFocus() {
    this.button.blur();
  }
  handleSlotChange() {
    this.hasLabel = hasSlot(this.host);
    this.hasPrefix = hasSlot(this.host, 'prefix');
    this.hasSuffix = hasSlot(this.host, 'suffix');
  }
  handleBlur() {
    this.hasFocus = false;
    this.slBlur.emit();
  }
  handleFocus() {
    this.hasFocus = true;
    this.slFocus.emit();
  }
  handleClick(event) {
    if (this.disabled || this.loading) {
      event.preventDefault();
      event.stopPropagation();
    }
  }
  render() {
    const isLink = this.href ? true : false;
    const isButton = !isLink;
    const Button = isLink ? 'a' : 'button';
    return (h(Button, { ref: el => (this.button = el), part: "base", class: {
        button: true,
        // Types
        'button--default': this.type === 'default',
        'button--primary': this.type === 'primary',
        'button--success': this.type === 'success',
        'button--info': this.type === 'info',
        'button--warning': this.type === 'warning',
        'button--danger': this.type === 'danger',
        'button--text': this.type === 'text',
        // Sizes
        'button--small': this.size === 'small',
        'button--medium': this.size === 'medium',
        'button--large': this.size === 'large',
        // Modifiers
        'button--caret': this.caret,
        'button--circle': this.circle,
        'button--disabled': this.disabled,
        'button--focused': this.hasFocus,
        'button--loading': this.loading,
        'button--pill': this.pill,
        'button--has-label': this.hasLabel,
        'button--has-prefix': this.hasPrefix,
        'button--has-suffix': this.hasSuffix
      }, disabled: isButton ? this.disabled : null, type: isButton ? (this.submit ? 'submit' : 'button') : null, name: isButton ? this.name : null, value: isButton ? this.value : null, href: isLink && this.href, target: isLink && this.target ? this.target : null, download: isLink && this.download ? this.download : null, rel: isLink && this.target ? 'noreferrer noopener' : null, onBlur: this.handleBlur, onFocus: this.handleFocus, onClick: this.handleClick }, h("span", { part: "prefix", class: "button__prefix" }, h("slot", { onSlotchange: this.handleSlotChange, name: "prefix" })), h("span", { part: "label", class: "button__label" }, h("slot", { onSlotchange: this.handleSlotChange })), h("span", { part: "suffix", class: "button__suffix" }, h("slot", { onSlotchange: this.handleSlotChange, name: "suffix" })), this.caret && (h("span", { part: "caret", class: "button__caret" }, h("svg", { viewBox: "0 0 24 24", fill: "none", stroke: "currentColor", "stroke-width": "2", "stroke-linecap": "round", "stroke-linejoin": "round" }, h("polyline", { points: "6 9 12 15 18 9" })))), this.loading && h("sl-spinner", null)));
  }
  get host() { return getElement(this); }
};
Button.style = buttonCss;

const inputCss = ":host{position:relative;box-sizing:border-box}:host *,:host *:before,:host *:after{box-sizing:inherit}.form-control .form-control__label{display:none}.form-control .form-control__help-text{display:none}.form-control--has-label .form-control__label{display:inline-block;color:var(--sl-input-label-color);margin-bottom:var(--sl-spacing-xxx-small)}.form-control--has-label.form-control--small .form-control__label{font-size:var(--sl-input-label-font-size-small)}.form-control--has-label.form-control--medium .form-control__label{font-size:var(--sl-input-label-font-size-medium)}.form-control--has-label.form-control--large .form-control_label{font-size:var(--sl-input-label-font-size-large)}.form-control--has-help-text .form-control__help-text{display:block;color:var(--sl-input-help-text-color)}.form-control--has-help-text .form-control__help-text ::slotted(*){margin-top:var(--sl-spacing-xxx-small)}.form-control--has-help-text.form-control--small .form-control__help-text{font-size:var(--sl-input-help-text-font-size-small)}.form-control--has-help-text.form-control--medium .form-control__help-text{font-size:var(--sl-input-help-text-font-size-medium)}.form-control--has-help-text.form-control--large .form-control__help-text{font-size:var(--sl-input-help-text-font-size-large)}:host{--focus-ring:0 0 0 var(--sl-focus-ring-width) var(--sl-focus-ring-color-primary);display:block}.input{flex:1 1 auto;display:inline-flex;align-items:stretch;justify-content:start;position:relative;width:100%;font-family:var(--sl-input-font-family);font-weight:var(--sl-input-font-weight);letter-spacing:var(--sl-input-letter-spacing);background-color:var(--sl-input-background-color);border:solid var(--sl-input-border-width) var(--sl-input-border-color);vertical-align:middle;overflow:hidden;transition:var(--sl-transition-fast) color, var(--sl-transition-fast) border, var(--sl-transition-fast) box-shadow;cursor:text}.input:hover:not(.input--disabled){background-color:var(--sl-input-background-color-hover);border-color:var(--sl-input-border-color-hover)}.input:hover:not(.input--disabled) .input__control{color:var(--sl-input-color-hover)}.input.input--focused:not(.input--disabled){background-color:var(--sl-input-background-color-focus);border-color:var(--sl-input-border-color-focus);box-shadow:var(--focus-ring)}.input.input--focused:not(.input--disabled) .input__control{color:var(--sl-input-color-focus)}.input.input--disabled{background-color:var(--sl-input-background-color-disabled);border-color:var(--sl-input-border-color-disabled);opacity:0.5;cursor:not-allowed}.input.input--disabled .input__control{color:var(--sl-input-color-disabled)}.input.input--disabled .input__control::placeholder{color:var(--sl-input-placeholder-color-disabled)}.input__control{flex:1 1 auto;font-family:inherit;font-size:inherit;font-weight:inherit;min-width:0;height:100%;color:var(--sl-input-color);border:none;background:none;box-shadow:none;padding:0;margin:0;cursor:inherit;-webkit-appearance:none}.input__control::-webkit-search-decoration,.input__control::-webkit-search-cancel-button,.input__control::-webkit-search-results-button,.input__control::-webkit-search-results-decoration{-webkit-appearance:none}.input__control:-webkit-autofill,.input__control:-webkit-autofill:hover,.input__control:-webkit-autofill:focus,.input__control:-webkit-autofill:active{box-shadow:0 0 0 var(--sl-input-height-large) var(--sl-input-background-color-hover) inset !important;-webkit-text-fill-color:var(--sl-color-primary-500)}.input__control::placeholder{color:var(--sl-input-placeholder-color);user-select:none}.input__control:focus{outline:none}.input__prefix,.input__suffix{display:inline-flex;flex:0 0 auto;align-items:center;cursor:default}.input__prefix ::slotted(sl-icon),.input__suffix ::slotted(sl-icon){color:var(--sl-input-icon-color)}.input--small{border-radius:var(--sl-input-border-radius-small);font-size:var(--sl-input-font-size-small);height:var(--sl-input-height-small)}.input--small .input__control{height:calc(var(--sl-input-height-small) - var(--sl-input-border-width) * 2);margin:0 var(--sl-input-spacing-small)}.input--small .input__clear,.input--small .input__password-toggle{margin-right:var(--sl-input-spacing-small)}.input--small .input__prefix ::slotted(*){margin-left:var(--sl-input-spacing-small)}.input--small .input__suffix ::slotted(*){margin-right:var(--sl-input-spacing-small)}.input--medium{border-radius:var(--sl-input-border-radius-medium);font-size:var(--sl-input-font-size-medium);height:var(--sl-input-height-medium)}.input--medium .input__control{height:calc(var(--sl-input-height-medium) - var(--sl-input-border-width) * 2);margin:0 var(--sl-input-spacing-medium)}.input--medium .input__clear,.input--medium .input__password-toggle{margin-right:var(--sl-input-spacing-medium)}.input--medium .input__prefix ::slotted(*){margin-left:var(--sl-input-spacing-medium)}.input--medium .input__suffix ::slotted(*){margin-right:var(--sl-input-spacing-medium)}.input--large{border-radius:var(--sl-input-border-radius-large);font-size:var(--sl-input-font-size-large);height:var(--sl-input-height-large)}.input--large .input__control{height:calc(var(--sl-input-height-large) - var(--sl-input-border-width) * 2);margin:0 var(--sl-input-spacing-large)}.input--large .input__clear,.input--large .input__password-toggle{margin-right:var(--sl-input-spacing-large)}.input--large .input__prefix ::slotted(*){margin-left:var(--sl-input-spacing-large)}.input--large .input__suffix ::slotted(*){margin-right:var(--sl-input-spacing-large)}.input--pill.input--small{border-radius:var(--sl-input-height-small)}.input--pill.input--medium{border-radius:var(--sl-input-height-medium)}.input--pill.input--large{border-radius:var(--sl-input-height-large)}.input__clear,.input__password-toggle{display:inline-flex;align-items:center;font-size:inherit;color:var(--sl-input-icon-color);border:none;background:none;padding:0;transition:var(--sl-transition-fast) color;cursor:pointer}.input__clear:hover,.input__password-toggle:hover{color:var(--sl-input-icon-color-hover)}.input__clear:focus,.input__password-toggle:focus{outline:none}.input--empty .input__clear{visibility:hidden}";

let id = 0;
const Input = class {
  constructor(hostRef) {
    registerInstance(this, hostRef);
    this.slChange = createEvent(this, "sl-change", 7);
    this.slClear = createEvent(this, "sl-clear", 7);
    this.slInput = createEvent(this, "sl-input", 7);
    this.slFocus = createEvent(this, "sl-focus", 7);
    this.slBlur = createEvent(this, "sl-blur", 7);
    this.inputId = `input-${++id}`;
    this.labelId = `input-label-${id}`;
    this.helpTextId = `input-help-text-${id}`;
    this.hasFocus = false;
    this.hasHelpTextSlot = false;
    this.hasLabelSlot = false;
    this.isPasswordVisible = false;
    /** The input's type. */
    this.type = 'text';
    /** The input's size. */
    this.size = 'medium';
    /** The input's name attribute. */
    this.name = '';
    /** The input's value attribute. */
    this.value = '';
    /** Set to true to draw a pill-style input with rounded edges. */
    this.pill = false;
    /** The input's label. Alternatively, you can use the label slot. */
    this.label = '';
    /** The input's help text. Alternatively, you can use the help-text slot. */
    this.helpText = '';
    /** Set to true to disable the input. */
    this.disabled = false;
    /** Set to true to make the input readonly. */
    this.readonly = false;
    /**
     * This will be true when the control is in an invalid state. Validity is determined by props such as `type`,
     * `required`, `minlength`, `maxlength`, and `pattern` using the browser's constraint validation API.
     */
    this.invalid = false;
    /** Set to true to add a clear button when the input is populated. */
    this.clearable = false;
    /** Set to true to add a password toggle button for password inputs. */
    this.togglePassword = false;
  }
  handleLabelChange() {
    this.handleSlotChange();
  }
  handleValueChange() {
    // In rare cases, the watcher may be called before render so we need to make sure the input exists
    this.invalid = this.input ? !this.input.checkValidity() : false;
  }
  connectedCallback() {
    this.handleChange = this.handleChange.bind(this);
    this.handleInput = this.handleInput.bind(this);
    this.handleInvalid = this.handleInvalid.bind(this);
    this.handleBlur = this.handleBlur.bind(this);
    this.handleFocus = this.handleFocus.bind(this);
    this.handleClearClick = this.handleClearClick.bind(this);
    this.handlePasswordToggle = this.handlePasswordToggle.bind(this);
    this.handleSlotChange = this.handleSlotChange.bind(this);
    this.host.shadowRoot.addEventListener('slotchange', this.handleSlotChange);
  }
  componentWillLoad() {
    this.handleSlotChange();
  }
  disconnectedCallback() {
    this.host.shadowRoot.removeEventListener('slotchange', this.handleSlotChange);
  }
  /** Sets focus on the input. */
  async setFocus(options) {
    this.input.focus(options);
  }
  /** Removes focus from the input. */
  async removeFocus() {
    this.input.blur();
  }
  /** Selects all the text in the input. */
  async select() {
    return this.input.select();
  }
  /** Sets the start and end positions of the text selection (0-based). */
  async setSelectionRange(selectionStart, selectionEnd, selectionDirection = 'none') {
    return this.input.setSelectionRange(selectionStart, selectionEnd, selectionDirection);
  }
  /** Replaces a range of text with a new string. */
  async setRangeText(replacement, start, end, selectMode = 'preserve') {
    this.input.setRangeText(replacement, start, end, selectMode);
    if (this.value !== this.input.value) {
      this.value = this.input.value;
      this.slChange.emit();
      this.slInput.emit();
    }
  }
  /** Checks for validity and shows the browser's validation message if the control is invalid. */
  async reportValidity() {
    return this.input.reportValidity();
  }
  /** Sets a custom validation message. If `message` is not empty, the field will be considered invalid. */
  async setCustomValidity(message) {
    this.input.setCustomValidity(message);
    this.invalid = !this.input.checkValidity();
  }
  handleChange() {
    this.value = this.input.value;
    this.slChange.emit();
  }
  handleInput() {
    this.value = this.input.value;
    this.slInput.emit();
  }
  handleInvalid() {
    this.invalid = true;
  }
  handleBlur() {
    this.hasFocus = false;
    this.slBlur.emit();
  }
  handleFocus() {
    this.hasFocus = true;
    this.slFocus.emit();
  }
  handleClearClick(event) {
    this.value = '';
    this.slClear.emit();
    this.slInput.emit();
    this.slChange.emit();
    this.input.focus();
    event.stopPropagation();
  }
  handlePasswordToggle() {
    this.isPasswordVisible = !this.isPasswordVisible;
  }
  handleSlotChange() {
    this.hasHelpTextSlot = hasSlot(this.host, 'help-text');
    this.hasLabelSlot = hasSlot(this.host, 'label');
  }
  render() {
    var _a;
    return (h(FormControl, { inputId: this.inputId, label: this.label, labelId: this.labelId, hasLabelSlot: this.hasLabelSlot, helpTextId: this.helpTextId, helpText: this.helpText, hasHelpTextSlot: this.hasHelpTextSlot, size: this.size }, h("div", { part: "base", class: {
        input: true,
        // Sizes
        'input--small': this.size === 'small',
        'input--medium': this.size === 'medium',
        'input--large': this.size === 'large',
        // States
        'input--pill': this.pill,
        'input--disabled': this.disabled,
        'input--focused': this.hasFocus,
        'input--empty': ((_a = this.value) === null || _a === void 0 ? void 0 : _a.length) === 0,
        'input--invalid': this.invalid
      } }, h("span", { part: "prefix", class: "input__prefix" }, h("slot", { name: "prefix" })), h("input", { part: "input", ref: el => (this.input = el), id: this.inputId, class: "input__control", type: this.type === 'password' && this.isPasswordVisible ? 'text' : this.type, name: this.name, placeholder: this.placeholder, disabled: this.disabled, readonly: this.readonly, minLength: this.minlength, maxLength: this.maxlength, min: this.min, max: this.max, step: this.step, value: this.value, autoCapitalize: this.autocapitalize, autoComplete: this.autocomplete, autoCorrect: this.autocorrect, autoFocus: this.autofocus, spellcheck: this.spellcheck, pattern: this.pattern, required: this.required, inputMode: this.inputmode, "aria-labelledby": this.labelId, "aria-describedby": this.helpTextId, "aria-invalid": this.invalid ? 'true' : 'false', onChange: this.handleChange, onInput: this.handleInput, onInvalid: this.handleInvalid, onFocus: this.handleFocus, onBlur: this.handleBlur }), this.clearable && (h("button", { part: "clear-button", class: "input__clear", type: "button", onClick: this.handleClearClick, tabindex: "-1" }, h("slot", { name: "clear-icon" }, h("sl-icon", { name: "x-circle" })))), this.togglePassword && (h("button", { part: "password-toggle-button", class: "input__password-toggle", type: "button", onClick: this.handlePasswordToggle, tabindex: "-1" }, this.isPasswordVisible ? (h("slot", { name: "show-password-icon" }, h("sl-icon", { name: "eye-slash" }))) : (h("slot", { name: "hide-password-icon" }, ' ', h("sl-icon", { name: "eye" }))))), h("span", { part: "suffix", class: "input__suffix" }, h("slot", { name: "suffix" })))));
  }
  get host() { return getElement(this); }
  static get watchers() { return {
    "helpText": ["handleLabelChange"],
    "label": ["handleLabelChange"],
    "value": ["handleValueChange"]
  }; }
};
Input.style = inputCss;

export { Button as sl_button, Input as sl_input };
