import { r as registerInstance, h } from './index-9f8c8536.js';

const menuDividerCss = ":host{position:relative;box-sizing:border-box}:host *,:host *:before,:host *:after{box-sizing:inherit}:host{display:block}.menu-divider{border-top:solid 1px var(--sl-panel-border-color);margin:var(--sl-spacing-x-small) 0}";

const MenuDivider = class {
  constructor(hostRef) {
    registerInstance(this, hostRef);
  }
  render() {
    return h("div", { part: "base", class: "menu-divider", role: "separator", "aria-hidden": "true" });
  }
};
MenuDivider.style = menuDividerCss;

export { MenuDivider as sl_menu_divider };
