import { r as registerInstance, c as createEvent, h, g as getElement } from './index-9f8c8536.js';
import { g as getTextContent, h as hasSlot } from './slot-ff7446e5.js';
import { F as FormControl } from './form-control-4aacb3e8.js';

const selectCss = ":host{position:relative;box-sizing:border-box}:host *,:host *:before,:host *:after{box-sizing:inherit}.form-control .form-control__label{display:none}.form-control .form-control__help-text{display:none}.form-control--has-label .form-control__label{display:inline-block;color:var(--sl-input-label-color);margin-bottom:var(--sl-spacing-xxx-small)}.form-control--has-label.form-control--small .form-control__label{font-size:var(--sl-input-label-font-size-small)}.form-control--has-label.form-control--medium .form-control__label{font-size:var(--sl-input-label-font-size-medium)}.form-control--has-label.form-control--large .form-control_label{font-size:var(--sl-input-label-font-size-large)}.form-control--has-help-text .form-control__help-text{display:block;color:var(--sl-input-help-text-color)}.form-control--has-help-text .form-control__help-text ::slotted(*){margin-top:var(--sl-spacing-xxx-small)}.form-control--has-help-text.form-control--small .form-control__help-text{font-size:var(--sl-input-help-text-font-size-small)}.form-control--has-help-text.form-control--medium .form-control__help-text{font-size:var(--sl-input-help-text-font-size-medium)}.form-control--has-help-text.form-control--large .form-control__help-text{font-size:var(--sl-input-help-text-font-size-large)}:host{--focus-ring:0 0 0 var(--sl-focus-ring-width) var(--sl-focus-ring-color-primary);display:block}.select{display:block}.select__box{display:inline-flex;align-items:center;justify-content:start;position:relative;width:100%;font-family:var(--sl-input-font-family);font-weight:var(--sl-input-font-weight);letter-spacing:var(--sl-input-letter-spacing);background-color:var(--sl-input-background-color);border:solid var(--sl-input-border-width) var(--sl-input-border-color);vertical-align:middle;overflow:hidden;transition:var(--sl-transition-fast) color, var(--sl-transition-fast) border, var(--sl-transition-fast) box-shadow;cursor:pointer}.select:not(.select--disabled) .select__box:hover{background-color:var(--sl-input-background-color-hover);border-color:var(--sl-input-border-color-hover);color:var(--sl-input-color-hover)}.select:not(.select--disabled) .select__box:focus{background-color:var(--sl-input-background-color-focus);border-color:var(--sl-input-border-color-focus);box-shadow:var(--focus-ring);outline:none;color:var(--sl-input-color-focus)}.select--disabled .select__box{background-color:var(--sl-input-background-color-disabled);border-color:var(--sl-input-border-color-disabled);color:var(--sl-input-color-disabled);opacity:0.5;cursor:not-allowed;outline:none}.select--disabled .select__tags,.select--disabled .select__clear{pointer-events:none}.select__label{flex:1 1 auto;display:flex;align-items:center;user-select:none;scrollbar-width:none;-ms-overflow-style:none;overflow-x:auto;overflow-y:hidden;white-space:nowrap}.select__label::-webkit-scrollbar{width:0;height:0}.select__clear{flex:0 0 auto}.select__icon{flex:0 0 auto;display:inline-flex;transition:var(--sl-transition-medium) transform ease}.select--open .select__icon{transform:rotate(-180deg)}.select--placeholder-visible .select__label{color:var(--sl-input-placeholder-color)}.select--disabled.select--placeholder-visible .select__label{color:var(--sl-input-placeholder-color-disabled)}.select__tags{display:inline-flex;align-items:center;flex-wrap:wrap;justify-content:left;margin-left:var(--sl-spacing-xx-small)}.select__hidden-select{clip:rect(0 0 0 0);clip-path:inset(50%);height:1px;overflow:hidden;position:absolute;white-space:nowrap;width:1px;position:absolute;top:0;left:0;width:100%;height:100%}.select--small .select__box{border-radius:var(--sl-input-border-radius-small);font-size:var(--sl-input-font-size-small);min-height:var(--sl-input-height-small)}.select--small .select__label{margin:0 var(--sl-input-spacing-small)}.select--small .select__clear{margin-right:var(--sl-input-spacing-small)}.select--small .select__icon{margin-right:var(--sl-input-spacing-small)}.select--small .select__tags{padding-bottom:2px}.select--small .select__tags sl-tag{padding-top:2px}.select--small .select__tags sl-tag:not(:last-of-type){margin-right:var(--sl-spacing-xx-small)}.select--small.select--has-tags .select__label{margin-left:0}.select--medium .select__box{border-radius:var(--sl-input-border-radius-medium);font-size:var(--sl-input-font-size-medium);min-height:var(--sl-input-height-medium)}.select--medium .select__label{margin:0 var(--sl-input-spacing-medium)}.select--medium .select__clear{margin-right:var(--sl-input-spacing-medium)}.select--medium .select__icon{margin-right:var(--sl-input-spacing-medium)}.select--medium .select__tags{padding-bottom:3px}.select--medium .select__tags sl-tag{padding-top:3px}.select--medium .select__tags sl-tag:not(:last-of-type){margin-right:var(--sl-spacing-xx-small)}.select--medium.select--has-tags .select__label{margin-left:0}.select--large .select__box{border-radius:var(--sl-input-border-radius-large);font-size:var(--sl-input-font-size-large);min-height:var(--sl-input-height-large)}.select--large .select__label{margin:0 var(--sl-input-spacing-large)}.select--large .select__clear{margin-right:var(--sl-input-spacing-large)}.select--large .select__icon{margin-right:var(--sl-input-spacing-large)}.select--large .select__tags{padding-bottom:4px}.select--large .select__tags sl-tag{padding-top:4px}.select--large .select__tags sl-tag:not(:last-of-type){margin-right:var(--sl-spacing-xx-small)}.select--large.select--has-tags .select__label{margin-left:0}.select--pill.select--small .select__box{border-radius:var(--sl-input-height-small)}.select--pill.select--medium .select__box{border-radius:var(--sl-input-height-medium)}.select--pill.select--large .select__box{border-radius:var(--sl-input-height-large)}";

let id = 0;
const Select = class {
  constructor(hostRef) {
    registerInstance(this, hostRef);
    this.slChange = createEvent(this, "sl-change", 7);
    this.slFocus = createEvent(this, "sl-focus", 7);
    this.slBlur = createEvent(this, "sl-blur", 7);
    this.inputId = `select-${++id}`;
    this.labelId = `select-label-${id}`;
    this.helpTextId = `select-help-text-${id}`;
    this.hasFocus = false;
    this.hasHelpTextSlot = false;
    this.hasLabelSlot = false;
    this.isOpen = false;
    this.items = [];
    this.displayLabel = '';
    this.displayTags = [];
    /** Set to true to enable multiselect. */
    this.multiple = false;
    /**
     * The maximum number of tags to show when `multiple` is true. After the maximum, "+n" will be shown to indicate the
     * number of additional items that are selected. Set to -1 to remove the limit.
     */
    this.maxTagsVisible = 3;
    /** Set to true to disable the select control. */
    this.disabled = false;
    /** The select's name. */
    this.name = '';
    /** The select's placeholder text. */
    this.placeholder = '';
    /** The select's size. */
    this.size = 'medium';
    /**
     * Enable this option to prevent the panel from being clipped when the component is placed inside a container with
     * `overflow: auto|scroll`.
     */
    this.hoist = false;
    /** The value of the control. This will be a string or an array depending on `multiple`. */
    this.value = '';
    /** Set to true to draw a pill-style select with rounded edges. */
    this.pill = false;
    /** The select's label. Alternatively, you can use the label slot. */
    this.label = '';
    /** The select's help text. Alternatively, you can use the help-text slot. */
    this.helpText = '';
    /** The select's required attribute. */
    this.required = false;
    /** Set to true to add a clear button when the select is populated. */
    this.clearable = false;
    /** This will be true when the control is in an invalid state. Validity is determined by the `required` prop. */
    this.invalid = false;
  }
  handleDisabledChange() {
    if (this.disabled && this.isOpen) {
      this.dropdown.hide();
    }
  }
  handleLabelChange() {
    this.handleSlotChange();
  }
  handleMultipleChange() {
    // Cast to array | string based on `this.multiple`
    const value = this.getValueAsArray();
    this.value = this.multiple ? value : value[0] || '';
    this.syncItemsFromValue();
  }
  handleValueChange() {
    this.syncItemsFromValue();
    this.slChange.emit();
  }
  connectedCallback() {
    this.handleBlur = this.handleBlur.bind(this);
    this.handleFocus = this.handleFocus.bind(this);
    this.handleClearClick = this.handleClearClick.bind(this);
    this.handleKeyDown = this.handleKeyDown.bind(this);
    this.handleLabelClick = this.handleLabelClick.bind(this);
    this.handleMenuHide = this.handleMenuHide.bind(this);
    this.handleMenuShow = this.handleMenuShow.bind(this);
    this.handleMenuSelect = this.handleMenuSelect.bind(this);
    this.handleSlotChange = this.handleSlotChange.bind(this);
    this.handleTagInteraction = this.handleTagInteraction.bind(this);
    this.host.shadowRoot.addEventListener('slotchange', this.handleSlotChange);
  }
  componentWillLoad() {
    this.handleSlotChange();
  }
  componentDidLoad() {
    this.resizeObserver = new ResizeObserver(() => this.resizeMenu());
    this.reportDuplicateItemValues();
    // We need to do an initial sync after the component has rendered, so this will suppress the re-render warning
    requestAnimationFrame(() => this.syncItemsFromValue());
  }
  disconnectedCallback() {
    this.host.shadowRoot.removeEventListener('slotchange', this.handleSlotChange);
  }
  /** Checks for validity and shows the browser's validation message if the control is invalid. */
  async reportValidity() {
    return this.input.reportValidity();
  }
  /** Sets a custom validation message. If `message` is not empty, the field will be considered invalid. */
  async setCustomValidity(message) {
    this.input.setCustomValidity(message);
    this.invalid = !this.input.checkValidity();
  }
  getItemLabel(item) {
    const slot = item.shadowRoot.querySelector('slot:not([name])');
    return getTextContent(slot);
  }
  getItems() {
    return [...this.host.querySelectorAll('sl-menu-item')];
  }
  getValueAsArray() {
    return Array.isArray(this.value) ? this.value : [this.value];
  }
  handleBlur() {
    this.hasFocus = false;
    this.slBlur.emit();
  }
  handleFocus() {
    this.hasFocus = true;
    this.slFocus.emit();
  }
  handleClearClick(event) {
    event.stopPropagation();
    this.value = this.multiple ? [] : '';
    this.syncItemsFromValue();
  }
  handleKeyDown(event) {
    const target = event.target;
    const items = this.getItems();
    const firstItem = items[0];
    const lastItem = items[items.length - 1];
    // Ignore key presses on tags
    if (target.tagName.toLowerCase() === 'sl-tag') {
      return;
    }
    // Tabbing out of the control closes it
    if (event.key === 'Tab') {
      if (this.isOpen) {
        this.dropdown.hide();
      }
      return;
    }
    // Up/down opens the menu
    if (['ArrowDown', 'ArrowUp'].includes(event.key)) {
      event.preventDefault();
      // Show the menu if it's not already open
      if (!this.isOpen) {
        this.dropdown.show();
      }
      // Focus on a menu item
      if (event.key === 'ArrowDown' && firstItem) {
        firstItem.setFocus();
        return;
      }
      if (event.key === 'ArrowUp' && lastItem) {
        lastItem.setFocus();
        return;
      }
    }
    // All other keys open the menu and initiate type to select
    if (!this.isOpen) {
      event.stopPropagation();
      event.preventDefault();
      this.dropdown.show();
      this.menu.typeToSelect(event.key);
    }
  }
  handleLabelClick() {
    this.box.focus();
  }
  handleMenuSelect(event) {
    const item = event.detail.item;
    if (this.multiple) {
      this.value = this.value.includes(item.value)
        ? this.value.filter(v => v !== item.value)
        : [...this.value, item.value];
    }
    else {
      this.value = item.value;
    }
    this.syncItemsFromValue();
  }
  handleMenuShow(event) {
    if (this.disabled) {
      event.preventDefault();
      return;
    }
    this.resizeMenu();
    this.resizeObserver.observe(this.host);
    this.isOpen = true;
  }
  handleMenuHide() {
    this.resizeObserver.unobserve(this.host);
    this.isOpen = false;
  }
  handleSlotChange() {
    this.hasHelpTextSlot = hasSlot(this.host, 'help-text');
    this.hasLabelSlot = hasSlot(this.host, 'label');
    this.syncItemsFromValue();
    this.reportDuplicateItemValues();
  }
  handleTagInteraction(event) {
    // Don't toggle the menu when a tag's clear button is activated
    const path = event.composedPath();
    const clearButton = path.find(el => {
      if (el instanceof HTMLElement) {
        const element = el;
        return element.classList.contains('tag__clear');
      }
    });
    if (clearButton) {
      event.stopPropagation();
    }
  }
  reportDuplicateItemValues() {
    const items = this.getItems();
    // Report duplicate values since they can break selection logic
    const duplicateValues = items.map(item => item.value).filter((e, i, a) => a.indexOf(e) !== i);
    if (duplicateValues.length) {
      throw new Error('Duplicate value found on <sl-menu-item> in <sl-select>: "' + duplicateValues.join('", "') + '"');
    }
  }
  resizeMenu() {
    this.menu.style.width = `${this.box.clientWidth}px`;
  }
  syncItemsFromValue() {
    const items = this.getItems();
    const value = this.getValueAsArray();
    // Sync checked states
    items.map(item => (item.checked = value.includes(item.value)));
    // Sync display label
    if (this.multiple) {
      const checkedItems = [];
      value.map(val => items.map(item => (item.value === val ? checkedItems.push(item) : null)));
      this.displayTags = checkedItems.map(item => {
        return (h("sl-tag", { exportparts: "base:tag", type: "info", size: this.size, pill: this.pill, clearable: true, onClick: this.handleTagInteraction, onKeyDown: this.handleTagInteraction, "onSl-clear": event => {
            event.stopPropagation();
            if (!this.disabled) {
              item.checked = false;
              this.syncValueFromItems();
            }
          } }, this.getItemLabel(item)));
      });
      if (this.maxTagsVisible > 0 && this.displayTags.length > this.maxTagsVisible) {
        const total = this.displayTags.length;
        this.displayLabel = '';
        this.displayTags = this.displayTags.slice(0, this.maxTagsVisible);
        this.displayTags.push(h("sl-tag", { exportparts: "base:tag", type: "info", size: this.size }, "+", total - this.maxTagsVisible));
      }
    }
    else {
      const checkedItem = items.filter(item => item.value === value[0])[0];
      this.displayLabel = checkedItem ? this.getItemLabel(checkedItem) : '';
      this.displayTags = [];
    }
  }
  syncValueFromItems() {
    const items = this.getItems();
    const checkedItems = items.filter(item => item.checked);
    const checkedValues = checkedItems.map(item => item.value);
    if (this.multiple) {
      this.value = this.value.filter(val => checkedValues.includes(val));
    }
    else {
      this.value = checkedValues.length > 0 ? checkedValues[0] : '';
    }
  }
  render() {
    var _a;
    const hasSelection = this.multiple ? this.value.length > 0 : this.value !== '';
    return (h(FormControl, { inputId: this.inputId, label: this.label, labelId: this.labelId, hasLabelSlot: this.hasLabelSlot, helpTextId: this.helpTextId, helpText: this.helpText, hasHelpTextSlot: this.hasHelpTextSlot, size: this.size, onLabelClick: this.handleLabelClick }, h("sl-dropdown", { part: "base", ref: el => (this.dropdown = el), hoist: this.hoist, closeOnSelect: !this.multiple, containingElement: this.host, class: {
        select: true,
        'select--open': this.isOpen,
        'select--empty': ((_a = this.value) === null || _a === void 0 ? void 0 : _a.length) === 0,
        'select--focused': this.hasFocus,
        'select--clearable': this.clearable,
        'select--disabled': this.disabled,
        'select--multiple': this.multiple,
        'select--has-tags': this.multiple && hasSelection,
        'select--placeholder-visible': this.displayLabel === '',
        'select--small': this.size === 'small',
        'select--medium': this.size === 'medium',
        'select--large': this.size === 'large',
        'select--pill': this.pill,
        'select--invalid': this.invalid
      }, "onSl-show": this.handleMenuShow, "onSl-hide": this.handleMenuHide }, h("div", { slot: "trigger", ref: el => (this.box = el), id: this.inputId, class: "select__box", role: "combobox", "aria-labelledby": this.labelId, "aria-describedby": this.helpTextId, "aria-haspopup": "true", "aria-expanded": this.isOpen ? 'true' : 'false', tabIndex: this.disabled ? -1 : 0, onBlur: this.handleBlur, onFocus: this.handleFocus, onKeyDown: this.handleKeyDown }, h("div", { class: "select__label" }, this.displayTags.length ? (h("span", { part: "tags", class: "select__tags" }, this.displayTags)) : (this.displayLabel || this.placeholder)), this.clearable && hasSelection && (h("sl-icon-button", { exportparts: "base:clear-button", class: "select__clear", name: "x-circle", onClick: this.handleClearClick, tabindex: "-1" })), h("span", { part: "icon", class: "select__icon" }, h("sl-icon", { name: "chevron-down" })), h("input", { ref: el => (this.input = el), class: "select__hidden-select", "aria-hidden": "true", required: this.required, value: hasSelection ? '1' : '', tabIndex: -1 })), h("sl-menu", { ref: el => (this.menu = el), part: "menu", class: "select__menu", "onSl-select": this.handleMenuSelect }, h("slot", { onSlotchange: this.handleSlotChange })))));
  }
  get host() { return getElement(this); }
  static get watchers() { return {
    "disabled": ["handleDisabledChange"],
    "helpText": ["handleLabelChange"],
    "label": ["handleLabelChange"],
    "multiple": ["handleMultipleChange"],
    "value": ["handleValueChange"]
  }; }
};
Select.style = selectCss;

export { Select as sl_select };
