import { r as registerInstance, c as createEvent, h, g as getElement } from './index-9f8c8536.js';
import { h as hasSlot } from './slot-ff7446e5.js';
import { F as FormControl } from './form-control-4aacb3e8.js';

const textareaCss = ":host{position:relative;box-sizing:border-box}:host *,:host *:before,:host *:after{box-sizing:inherit}.form-control .form-control__label{display:none}.form-control .form-control__help-text{display:none}.form-control--has-label .form-control__label{display:inline-block;color:var(--sl-input-label-color);margin-bottom:var(--sl-spacing-xxx-small)}.form-control--has-label.form-control--small .form-control__label{font-size:var(--sl-input-label-font-size-small)}.form-control--has-label.form-control--medium .form-control__label{font-size:var(--sl-input-label-font-size-medium)}.form-control--has-label.form-control--large .form-control_label{font-size:var(--sl-input-label-font-size-large)}.form-control--has-help-text .form-control__help-text{display:block;color:var(--sl-input-help-text-color)}.form-control--has-help-text .form-control__help-text ::slotted(*){margin-top:var(--sl-spacing-xxx-small)}.form-control--has-help-text.form-control--small .form-control__help-text{font-size:var(--sl-input-help-text-font-size-small)}.form-control--has-help-text.form-control--medium .form-control__help-text{font-size:var(--sl-input-help-text-font-size-medium)}.form-control--has-help-text.form-control--large .form-control__help-text{font-size:var(--sl-input-help-text-font-size-large)}:host{display:block}.textarea{display:flex;align-items:center;position:relative;width:100%;font-family:var(--sl-input-font-family);font-weight:var(--sl-input-font-weight);line-height:var(--sl-line-height-normal);letter-spacing:var(--sl-input-letter-spacing);background-color:var(--sl-input-background-color);border:solid var(--sl-input-border-width) var(--sl-input-border-color);vertical-align:middle;transition:var(--sl-transition-fast) color, var(--sl-transition-fast) border, var(--sl-transition-fast) box-shadow;cursor:text}.textarea:hover:not(.textarea--disabled){background-color:var(--sl-input-background-color-hover);border-color:var(--sl-input-border-color-hover)}.textarea:hover:not(.textarea--disabled) .textarea__control{color:var(--sl-input-color-hover)}.textarea.textarea--focused:not(.textarea--disabled){background-color:var(--sl-input-background-color-focus);border-color:var(--sl-input-border-color-focus);box-shadow:0 0 0 var(--sl-focus-ring-width) var(--sl-focus-ring-color-primary);color:var(--sl-input-color-focus)}.textarea.textarea--focused:not(.textarea--disabled) .textarea__control{color:var(--sl-input-color-focus)}.textarea.textarea--disabled{background-color:var(--sl-input-background-color-disabled);border-color:var(--sl-input-border-color-disabled);opacity:0.5;cursor:not-allowed}.textarea.textarea--disabled .textarea__control{color:var(--sl-input-color-disabled)}.textarea.textarea--disabled .textarea__control::placeholder{color:var(--sl-input-placeholder-color-disabled)}.textarea__control{flex:1 1 auto;font-family:inherit;font-size:inherit;font-weight:inherit;line-height:1.4;color:var(--sl-input-color);border:none;background:none;box-shadow:none;cursor:inherit;-webkit-appearance:none}.textarea__control::-webkit-search-decoration,.textarea__control::-webkit-search-cancel-button,.textarea__control::-webkit-search-results-button,.textarea__control::-webkit-search-results-decoration{-webkit-appearance:none}.textarea__control::placeholder{color:var(--sl-input-placeholder-color);user-select:none}.textarea__control:focus{outline:none}.textarea--small{border-radius:var(--sl-input-border-radius-small);font-size:var(--sl-input-font-size-small)}.textarea--small .textarea__control{padding:0.5em var(--sl-input-spacing-small)}.textarea--medium{border-radius:var(--sl-input-border-radius-medium);font-size:var(--sl-input-font-size-medium)}.textarea--medium .textarea__control{padding:0.5em var(--sl-input-spacing-medium)}.textarea--large{border-radius:var(--sl-input-border-radius-large);font-size:var(--sl-input-font-size-large)}.textarea--large .textarea__control{padding:0.5em var(--sl-input-spacing-large)}.textarea--resize-none .textarea__control{resize:none}.textarea--resize-vertical .textarea__control{resize:vertical}.textarea--resize-auto .textarea__control{height:auto;resize:none}";

let id = 0;
const Textarea = class {
  constructor(hostRef) {
    registerInstance(this, hostRef);
    this.slChange = createEvent(this, "sl-change", 7);
    this.slInput = createEvent(this, "sl-input", 7);
    this.slFocus = createEvent(this, "sl-focus", 7);
    this.slBlur = createEvent(this, "sl-blur", 7);
    this.inputId = `textarea-${++id}`;
    this.labelId = `textarea-label-${id}`;
    this.helpTextId = `textarea-help-text-${id}`;
    this.hasFocus = false;
    this.hasHelpTextSlot = false;
    this.hasLabelSlot = false;
    /** The textarea's size. */
    this.size = 'medium';
    /** The textarea's name attribute. */
    this.name = '';
    /** The textarea's value attribute. */
    this.value = '';
    /** The textarea's label. Alternatively, you can use the label slot. */
    this.label = '';
    /** The textarea's help text. Alternatively, you can use the help-text slot. */
    this.helpText = '';
    /** The number of rows to display by default. */
    this.rows = 4;
    /** Controls how the textarea can be resized. */
    this.resize = 'vertical';
    /** Set to true to disable the textarea. */
    this.disabled = false;
    /** Set to true for a readonly textarea. */
    this.readonly = false;
    /**
     * This will be true when the control is in an invalid state. Validity is determined by props such as `required`,
     * `minlength`, and `maxlength` using the browser's constraint validation API.
     */
    this.invalid = false;
  }
  handleLabelChange() {
    this.handleSlotChange();
  }
  handleRowsChange() {
    this.setTextareaHeight();
  }
  handleValueChange() {
    // In rare cases, the watcher may be called before render so we need to make sure the textarea exists
    this.invalid = this.textarea ? !this.textarea.checkValidity() : false;
  }
  connectedCallback() {
    this.handleChange = this.handleChange.bind(this);
    this.handleInput = this.handleInput.bind(this);
    this.handleBlur = this.handleBlur.bind(this);
    this.handleFocus = this.handleFocus.bind(this);
    this.handleSlotChange = this.handleSlotChange.bind(this);
    this.host.shadowRoot.addEventListener('slotchange', this.handleSlotChange);
  }
  componentWillLoad() {
    this.handleSlotChange();
  }
  componentDidLoad() {
    this.setTextareaHeight();
    this.resizeObserver = new ResizeObserver(() => this.setTextareaHeight());
    this.resizeObserver.observe(this.textarea);
  }
  disconnectedCallback() {
    this.resizeObserver.unobserve(this.textarea);
    this.host.shadowRoot.removeEventListener('slotchange', this.handleSlotChange);
  }
  /** Sets focus on the textarea. */
  async setFocus(options) {
    this.textarea.focus(options);
  }
  /** Removes focus fromt the textarea. */
  async removeFocus() {
    this.textarea.blur();
  }
  /** Selects all the text in the input. */
  async select() {
    return this.textarea.select();
  }
  /** Sets the start and end positions of the text selection (0-based). */
  async setSelectionRange(selectionStart, selectionEnd, selectionDirection = 'none') {
    return this.textarea.setSelectionRange(selectionStart, selectionEnd, selectionDirection);
  }
  /** Replaces a range of text with a new string. */
  async setRangeText(replacement, start, end, selectMode = 'preserve') {
    this.textarea.setRangeText(replacement, start, end, selectMode);
    if (this.value !== this.textarea.value) {
      this.value = this.textarea.value;
      this.setTextareaHeight();
      this.slChange.emit();
      this.slInput.emit();
    }
  }
  /** Checks for validity and shows the browser's validation message if the control is invalid. */
  async reportValidity() {
    return this.textarea.reportValidity();
  }
  /** Sets a custom validation message. If `message` is not empty, the field will be considered invalid. */
  async setCustomValidity(message) {
    this.textarea.setCustomValidity(message);
    this.invalid = !this.textarea.checkValidity();
  }
  handleChange() {
    this.slChange.emit();
  }
  handleInput() {
    this.value = this.textarea.value;
    this.setTextareaHeight();
    this.slInput.emit();
  }
  handleBlur() {
    this.hasFocus = false;
    this.slBlur.emit();
  }
  handleFocus() {
    this.hasFocus = true;
    this.slFocus.emit();
  }
  handleSlotChange() {
    this.hasLabelSlot = hasSlot(this.host, 'label');
    this.hasHelpTextSlot = hasSlot(this.host, 'help-text');
  }
  setTextareaHeight() {
    if (this.resize === 'auto') {
      this.textarea.style.height = 'auto';
      this.textarea.style.height = this.textarea.scrollHeight + 'px';
    }
    else {
      this.textarea.style.height = undefined;
    }
  }
  render() {
    var _a;
    return (h(FormControl, { inputId: this.inputId, label: this.label, labelId: this.labelId, hasLabelSlot: this.hasLabelSlot, helpTextId: this.helpTextId, helpText: this.helpText, hasHelpTextSlot: this.hasHelpTextSlot, size: this.size }, h("div", { part: "base", class: {
        textarea: true,
        // Sizes
        'textarea--small': this.size === 'small',
        'textarea--medium': this.size === 'medium',
        'textarea--large': this.size === 'large',
        // States
        'textarea--disabled': this.disabled,
        'textarea--focused': this.hasFocus,
        'textarea--empty': ((_a = this.value) === null || _a === void 0 ? void 0 : _a.length) === 0,
        'textarea--invalid': this.invalid,
        // Modifiers
        'textarea--resize-none': this.resize === 'none',
        'textarea--resize-vertical': this.resize === 'vertical',
        'textarea--resize-auto': this.resize === 'auto'
      } }, h("textarea", { part: "textarea", ref: el => (this.textarea = el), id: this.inputId, class: "textarea__control", name: this.name, placeholder: this.placeholder, disabled: this.disabled, readOnly: this.readonly, rows: this.rows, minLength: this.minlength, maxLength: this.maxlength, value: this.value, autoCapitalize: this.autocapitalize, autoCorrect: this.autocorrect, autoFocus: this.autofocus, spellcheck: this.spellcheck, required: this.required, inputMode: this.inputmode, "aria-labelledby": this.labelId, onChange: this.handleChange, onInput: this.handleInput, onFocus: this.handleFocus, onBlur: this.handleBlur }))));
  }
  get host() { return getElement(this); }
  static get watchers() { return {
    "helpText": ["handleLabelChange"],
    "label": ["handleLabelChange"],
    "rows": ["handleRowsChange"],
    "value": ["handleValueChange"]
  }; }
};
Textarea.style = textareaCss;

export { Textarea as sl_textarea };
