/**
 * @since 2.0
 * @status stable
 *
 * @slot - The menu item's label.
 * @slot prefix - Used to prepend an icon or similar element to the menu item.
 * @slot suffix - Used to append an icon or similar element to the menu item.
 *
 * @part base - The component's base wrapper.
 * @part checked-icon - The container that wraps the checked icon.
 * @part prefix - The prefix container.
 * @part label - The menu item label.
 * @part suffix - The suffix container.
 */
export declare class MenuItem {
  menuItem: HTMLElement;
  hasFocus: boolean;
  /** Set to true to draw the item in a checked state. */
  checked: boolean;
  /** A unique value to store in the menu item. This can be used as a way to identify menu items when selected. */
  value: string;
  /** Set to true to draw the menu item in a disabled state. */
  disabled: boolean;
  connectedCallback(): void;
  /** Sets focus on the button. */
  setFocus(options?: FocusOptions): Promise<void>;
  /** Removes focus from the button. */
  removeFocus(): Promise<void>;
  handleBlur(): void;
  handleFocus(): void;
  handleMouseEnter(): void;
  handleMouseLeave(): void;
  render(): any;
}
