/// <reference types="resize-observer-browser" />
import { EventEmitter } from '../../stencil-public-runtime';
/**
 * @since 2.0
 * @status stable
 *
 * @slot label - The input's label. Alternatively, you can use the label prop.
 * @slot help-text - Help text that describes how to use the input. Alternatively, you can use the help-text prop.
 *
 * @part base - The component's base wrapper.
 * @part input - The native range input.
 * @part tooltip - The range tooltip.
 */
export declare class Range {
  input: HTMLInputElement;
  output: HTMLElement;
  inputId: string;
  labelId: string;
  helpTextId: string;
  resizeObserver: ResizeObserver;
  host: HTMLSlRangeElement;
  hasFocus: boolean;
  hasHelpTextSlot: boolean;
  hasLabelSlot: boolean;
  hasTooltip: boolean;
  /** The input's name attribute. */
  name: string;
  /** The input's value attribute. */
  value: number;
  /** The range's label. Alternatively, you can use the label slot. */
  label: string;
  /** The range's help text. Alternatively, you can use the help-text slot. */
  helpText: string;
  /** Set to true to disable the input. */
  disabled: boolean;
  /**
   * This will be true when the control is in an invalid state. Validity in range inputs is determined by the message
   * provided by the `setCustomValidity` method.
   */
  invalid: boolean;
  /** The input's min attribute. */
  min: number;
  /** The input's max attribute. */
  max: number;
  /** The input's step attribute. */
  step: number;
  /** The preferred placedment of the tooltip. */
  tooltip: 'top' | 'bottom' | 'none';
  /** A function used to format the tooltip's value. */
  tooltipFormatter: (value: number) => string;
  handleLabelChange(): void;
  /** Emitted when the control's value changes. */
  slChange: EventEmitter;
  /** Emitted when the control loses focus. */
  slBlur: EventEmitter;
  /** Emitted when the control gains focus. */
  slFocus: EventEmitter;
  connectedCallback(): void;
  componentWillLoad(): void;
  componentDidLoad(): void;
  disconnectedCallback(): void;
  /** Sets focus on the input. */
  setFocus(options?: FocusOptions): Promise<void>;
  /** Removes focus from the input. */
  removeFocus(): Promise<void>;
  /** Sets a custom validation message. If `message` is not empty, the field will be considered invalid. */
  setCustomValidity(message: string): Promise<void>;
  handleInput(): void;
  handleBlur(): void;
  handleFocus(): void;
  handleSlotChange(): void;
  handleTouchStart(): void;
  syncTooltip(): void;
  render(): any;
}
