import { EventEmitter } from '../../stencil-public-runtime';
/**
 * @since 2.0
 * @status stable
 *
 * @slot - The tab's label.
 *
 * @part base - The component's base wrapper.
 * @part close-button - The close button, which is the icon button's base wrapper.
 */
export declare class Tab {
  componentId: string;
  tab: HTMLElement;
  host: HTMLSlTabElement;
  /** The name of the tab panel the tab will control. The panel must be located in the same tab group. */
  panel: string;
  /** Set to true to draw the tab in an active state. */
  active: boolean;
  /** When true, the tab will be rendered with a close icon. */
  closable: boolean;
  /** Set to true to draw the tab in a disabled state. */
  disabled: boolean;
  /** Emitted when the tab is closable and the close button is activated. */
  slClose: EventEmitter;
  connectedCallback(): void;
  /** Sets focus to the tab. */
  setFocus(options?: FocusOptions): Promise<void>;
  /** Removes focus from the tab. */
  removeFocus(): Promise<void>;
  handleCloseClick(): void;
  render(): any;
}
