import {
  e
} from "./chunk.T6M3ZU4B.js";
import {
  __decorate,
  n,
  o,
  p,
  s
} from "./chunk.SXOXLYUK.js";

// _f6qjx70ca:/Users/claviska/Projects/shoelace/src/components/button-group/button-group.scss
var button_group_default = ":host {\n  position: relative;\n  box-sizing: border-box;\n}\n:host *, :host *:before, :host *:after {\n  box-sizing: inherit;\n}\n\n:host {\n  display: inline-block;\n}\n\n.button-group {\n  display: flex;\n  flex-wrap: nowrap;\n  position: relative;\n}\n\n::slotted(.sl-focus) {\n  z-index: 1;\n}";

// src/components/button-group/button-group.ts
var SlButtonGroup = class extends o {
  handleFocus(event) {
    const button = event.target;
    button.classList.add("sl-focus");
  }
  handleBlur(event) {
    const button = event.target;
    button.classList.remove("sl-focus");
  }
  render() {
    return p`
      <div
        part="base"
        class="button-group"
        aria-label=${this.label}
        @focusout=${this.handleBlur}
        @focusin=${this.handleFocus}
      >
        <slot></slot>
      </div>
    `;
  }
};
SlButtonGroup.styles = s(button_group_default);
__decorate([
  e()
], SlButtonGroup.prototype, "label", 2);
SlButtonGroup = __decorate([
  n("sl-button-group")
], SlButtonGroup);
var button_group_default2 = SlButtonGroup;

export {
  button_group_default2 as button_group_default
};
