import {
  RadioBase
} from "./chunk.7PKQGKRF.js";
import {
  l as l2
} from "./chunk.LOYEL7IY.js";
import {
  button_styles_default
} from "./chunk.OA5BPB3M.js";
import {
  HasSlotController
} from "./chunk.3IYPB6RR.js";
import {
  o
} from "./chunk.7BXY5XRG.js";
import {
  l
} from "./chunk.R37SUKY2.js";
import {
  e,
  n
} from "./chunk.72DLNKYZ.js";
import {
  __decorateClass
} from "./chunk.ICGTMF5Z.js";

// src/components/radio-button/radio-button.ts
var SlRadioButton = class extends RadioBase {
  constructor() {
    super(...arguments);
    this.hasSlotController = new HasSlotController(this, "[default]", "prefix", "suffix");
    this.variant = "default";
    this.size = "medium";
    this.invalid = false;
    this.pill = false;
  }
  render() {
    return l2`
      <button
        part="base"
        class=${o({
      button: true,
      "button--default": this.variant === "default",
      "button--primary": this.variant === "primary",
      "button--success": this.variant === "success",
      "button--neutral": this.variant === "neutral",
      "button--warning": this.variant === "warning",
      "button--danger": this.variant === "danger",
      "button--small": this.size === "small",
      "button--medium": this.size === "medium",
      "button--large": this.size === "large",
      "button--checked": this.checked,
      "button--disabled": this.disabled,
      "button--focused": this.hasFocus,
      "button--outline": true,
      "button--pill": this.pill,
      "button--has-label": this.hasSlotController.test("[default]"),
      "button--has-prefix": this.hasSlotController.test("prefix"),
      "button--has-suffix": this.hasSlotController.test("suffix")
    })}
        ?disabled=${this.disabled}
        type="button"
        name=${l(this.name)}
        value=${l(this.value)}
        @blur=${this.handleBlur}
        @focus=${this.handleFocus}
        @click=${this.handleClick}
      >
        <span part="prefix" class="button__prefix">
          <slot name="prefix"></slot>
        </span>
        <span part="label" class="button__label">
          <slot></slot>
        </span>
        <span part="suffix" class="button__suffix">
          <slot name="suffix"></slot>
        </span>
      </button>
    `;
  }
};
SlRadioButton.styles = button_styles_default;
__decorateClass([
  e({ reflect: true })
], SlRadioButton.prototype, "variant", 2);
__decorateClass([
  e({ reflect: true })
], SlRadioButton.prototype, "size", 2);
__decorateClass([
  e({ type: Boolean, reflect: true })
], SlRadioButton.prototype, "invalid", 2);
__decorateClass([
  e({ type: Boolean, reflect: true })
], SlRadioButton.prototype, "pill", 2);
SlRadioButton = __decorateClass([
  n("sl-radio-button")
], SlRadioButton);

export {
  SlRadioButton
};
