import {
  FormSubmitController
} from "./chunk.F5X7G75T.js";
import {
  watch
} from "./chunk.PQ5VRVXF.js";
import {
  emit
} from "./chunk.CDTZZV7W.js";
import {
  e,
  i,
  t
} from "./chunk.72DLNKYZ.js";
import {
  s
} from "./chunk.PEQICPKO.js";
import {
  __decorateClass
} from "./chunk.ICGTMF5Z.js";

// src/internal/radio.ts
var RadioBase = class extends s {
  constructor() {
    super(...arguments);
    this.formSubmitController = new FormSubmitController(this, {
      value: (control) => control.checked ? control.value : void 0
    });
    this.hasFocus = false;
    this.disabled = false;
    this.checked = false;
    this.invalid = false;
  }
  connectedCallback() {
    super.connectedCallback();
    this.setAttribute("role", "radio");
  }
  click() {
    this.input.click();
  }
  focus(options) {
    this.input.focus(options);
  }
  blur() {
    this.input.blur();
  }
  reportValidity() {
    return this.input.reportValidity();
  }
  setCustomValidity(message) {
    this.input.setCustomValidity(message);
    this.invalid = !this.input.checkValidity();
  }
  handleBlur() {
    this.hasFocus = false;
    emit(this, "sl-blur");
  }
  handleClick() {
    if (!this.disabled) {
      this.checked = true;
    }
  }
  handleFocus() {
    this.hasFocus = true;
    emit(this, "sl-focus");
  }
  handleCheckedChange() {
    this.setAttribute("aria-checked", this.checked ? "true" : "false");
    if (this.hasUpdated) {
      emit(this, "sl-change");
    }
  }
  handleDisabledChange() {
    this.setAttribute("aria-disabled", this.disabled ? "true" : "false");
    if (this.hasUpdated) {
      this.input.disabled = this.disabled;
      this.invalid = !this.input.checkValidity();
    }
  }
};
__decorateClass([
  i('input[type="radio"], button')
], RadioBase.prototype, "input", 2);
__decorateClass([
  t()
], RadioBase.prototype, "hasFocus", 2);
__decorateClass([
  e()
], RadioBase.prototype, "name", 2);
__decorateClass([
  e()
], RadioBase.prototype, "value", 2);
__decorateClass([
  e({ type: Boolean, reflect: true })
], RadioBase.prototype, "disabled", 2);
__decorateClass([
  e({ type: Boolean, reflect: true })
], RadioBase.prototype, "checked", 2);
__decorateClass([
  e({ type: Boolean, reflect: true })
], RadioBase.prototype, "invalid", 2);
__decorateClass([
  watch("checked")
], RadioBase.prototype, "handleCheckedChange", 1);
__decorateClass([
  watch("disabled", { waitUntilFirstUpdate: true })
], RadioBase.prototype, "handleDisabledChange", 1);

export {
  RadioBase
};
