import { LitElement } from 'lit';
import { FormSubmitController } from "./form";
export default abstract class RadioBase extends LitElement {
    input: HTMLInputElement;
    protected readonly formSubmitController: FormSubmitController;
    protected hasFocus: boolean;
    name: string;
    value: string;
    disabled: boolean;
    checked: boolean;
    invalid: boolean;
    connectedCallback(): void;
    click(): void;
    focus(options?: FocusOptions): void;
    blur(): void;
    reportValidity(): boolean;
    setCustomValidity(message: string): void;
    handleBlur(): void;
    handleClick(): void;
    handleFocus(): void;
    handleCheckedChange(): void;
    handleDisabledChange(): void;
}
