var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { LitElement } from 'lit';
import { property, query, state } from 'lit/decorators.js';
import { emit } from "./event";
import { FormSubmitController } from "./form";
import { watch } from "./watch";
export default class RadioBase extends LitElement {
    constructor() {
        super(...arguments);
        this.formSubmitController = new FormSubmitController(this, {
            value: (control) => (control.checked ? control.value : undefined)
        });
        this.hasFocus = false;
        this.disabled = false;
        this.checked = false;
        this.invalid = false;
    }
    connectedCallback() {
        super.connectedCallback();
        this.setAttribute('role', 'radio');
    }
    click() {
        this.input.click();
    }
    focus(options) {
        this.input.focus(options);
    }
    blur() {
        this.input.blur();
    }
    reportValidity() {
        return this.input.reportValidity();
    }
    setCustomValidity(message) {
        this.input.setCustomValidity(message);
        this.invalid = !this.input.checkValidity();
    }
    handleBlur() {
        this.hasFocus = false;
        emit(this, 'sl-blur');
    }
    handleClick() {
        if (!this.disabled) {
            this.checked = true;
        }
    }
    handleFocus() {
        this.hasFocus = true;
        emit(this, 'sl-focus');
    }
    handleCheckedChange() {
        this.setAttribute('aria-checked', this.checked ? 'true' : 'false');
        if (this.hasUpdated) {
            emit(this, 'sl-change');
        }
    }
    handleDisabledChange() {
        this.setAttribute('aria-disabled', this.disabled ? 'true' : 'false');
        if (this.hasUpdated) {
            this.input.disabled = this.disabled;
            this.invalid = !this.input.checkValidity();
        }
    }
}
__decorate([
    query('input[type="radio"], button')
], RadioBase.prototype, "input", void 0);
__decorate([
    state()
], RadioBase.prototype, "hasFocus", void 0);
__decorate([
    property()
], RadioBase.prototype, "name", void 0);
__decorate([
    property()
], RadioBase.prototype, "value", void 0);
__decorate([
    property({ type: Boolean, reflect: true })
], RadioBase.prototype, "disabled", void 0);
__decorate([
    property({ type: Boolean, reflect: true })
], RadioBase.prototype, "checked", void 0);
__decorate([
    property({ type: Boolean, reflect: true })
], RadioBase.prototype, "invalid", void 0);
__decorate([
    watch('checked')
], RadioBase.prototype, "handleCheckedChange", null);
__decorate([
    watch('disabled', { waitUntilFirstUpdate: true })
], RadioBase.prototype, "handleDisabledChange", null);
