import {
  spinner_styles_default
} from "./chunk.ZLRQFEYA.js";
import {
  LocalizeController
} from "./chunk.2SU6QBUU.js";
import {
  component_styles_default
} from "./chunk.INZSKSLC.js";
import {
  ShoelaceElement
} from "./chunk.I3G2R3VD.js";
import {
  x
} from "./chunk.OOP2EFQH.js";

// src/components/spinner/spinner.component.ts
var SlSpinner = class extends ShoelaceElement {
  constructor() {
    super(...arguments);
    this.localize = new LocalizeController(this);
  }
  render() {
    return x`
      <svg part="base" class="spinner" role="progressbar" aria-label=${this.localize.term("loading")}>
        <circle class="spinner__track"></circle>
        <circle class="spinner__indicator"></circle>
      </svg>
    `;
  }
};
SlSpinner.styles = [component_styles_default, spinner_styles_default];

export {
  SlSpinner
};
