import {
  n
} from "./chunk.OXME7NDH.js";
import {
  ScrollController
} from "./chunk.KRBNV2Z2.js";
import {
  SlCarouselItem
} from "./chunk.64WEZREQ.js";
import {
  clamp
} from "./chunk.HF7GESMZ.js";
import {
  AutoplayController
} from "./chunk.7XKEBFRL.js";
import {
  carousel_styles_default
} from "./chunk.ZNCCH2UB.js";
import {
  prefersReducedMotion
} from "./chunk.65AZ2BGN.js";
import {
  LocalizeController
} from "./chunk.L2X53Y67.js";
import {
  watch
} from "./chunk.VQ3XOPCT.js";
import {
  o
} from "./chunk.ORW72H2K.js";
import {
  ShoelaceElement,
  e,
  e2,
  i,
  t
} from "./chunk.XZ2J2V2F.js";
import {
  y
} from "./chunk.DUT32TWM.js";
import {
  __decorateClass
} from "./chunk.LKA3TPUC.js";

// node_modules/lit-html/directives/map.js
function* o2(o4, f) {
  if (void 0 !== o4) {
    let i2 = 0;
    for (const t2 of o4)
      yield f(t2, i2++);
  }
}

// node_modules/lit-html/directives/range.js
function* o3(o4, l, n2 = 1) {
  const t2 = void 0 === l ? 0 : o4;
  null != l || (l = o4);
  for (let o5 = t2; n2 > 0 ? o5 < l : l < o5; o5 += n2)
    yield o5;
}

// src/components/carousel/carousel.ts
var SlCarousel = class extends ShoelaceElement {
  constructor() {
    super(...arguments);
    this.loop = false;
    this.navigation = false;
    this.pagination = false;
    this.autoplay = false;
    this.autoplayInterval = 3e3;
    this.slidesPerPage = 1;
    this.slidesPerMove = 1;
    this.orientation = "horizontal";
    this.mouseDragging = false;
    this.activeSlide = 0;
    this.autoplayController = new AutoplayController(this, () => this.next());
    this.scrollController = new ScrollController(this);
    this.slides = this.getElementsByTagName("sl-carousel-item");
    // determines which slide is displayed
    // A map containing the state of all the slides
    this.intersectionObserverEntries = /* @__PURE__ */ new Map();
    this.localize = new LocalizeController(this);
    this.renderPagination = () => {
      const slides = this.getSlides();
      const slidesCount = slides.length;
      const { activeSlide, slidesPerPage } = this;
      const pagesCount = Math.ceil(slidesCount / slidesPerPage);
      const currentPage = Math.floor(activeSlide / slidesPerPage);
      return y`
      <nav part="pagination" role="tablist" class="carousel__pagination" aria-controls="scroll-container">
        ${o2(o3(pagesCount), (index) => {
        const isActive = index === currentPage;
        return y`
            <button
              part="pagination-item ${isActive ? "pagination-item--active" : ""}"
              class="${o({
          "carousel__pagination-item": true,
          "carousel__pagination-item--active": isActive
        })}"
              aria-selected="${isActive ? "true" : "false"}"
              aria-label="${this.localize.term("goToSlide", index + 1, pagesCount)}"
              role="tab"
              @click="${() => this.goToSlide(index * slidesPerPage)}"
            ></button>
          `;
      })}
      </nav>
    `;
    };
    this.renderNavigation = () => {
      const { loop, activeSlide } = this;
      const slides = this.getSlides();
      const slidesCount = slides.length;
      const prevEnabled = loop || activeSlide > 0;
      const nextEnabled = loop || activeSlide < slidesCount - 1;
      const isLtr = this.localize.dir() === "ltr";
      return y`
      <nav part="navigation" class="carousel__navigation">
        <button
          @click="${prevEnabled ? () => this.previous() : null}"
          aria-disabled="${prevEnabled ? "false" : "true"}"
          aria-controls="scroll-container"
          class="${o({
        "carousel__navigation-button": true,
        "carousel__navigation-button--previous": true,
        "carousel__navigation-button--disabled": !prevEnabled
      })}"
          aria-label="${this.localize.term("previousSlide")}"
          part="navigation-button navigation-button--previous"
        >
          <slot name="previous-icon">
            <sl-icon library="system" name="${isLtr ? "chevron-left" : "chevron-right"}"></sl-icon>
          </slot>
        </button>

        <button
          @click="${nextEnabled ? () => this.next() : null}"
          aria-disabled="${nextEnabled ? "false" : "true"}"
          aria-controls="scroll-container"
          class="${o({
        "carousel__navigation-button": true,
        "carousel__navigation-button--next": true,
        "carousel__navigation-button--disabled": !nextEnabled
      })}"
          aria-label="${this.localize.term("nextSlide")}"
          part="navigation-button navigation-button--next"
        >
          <slot name="next-icon">
            <sl-icon library="system" name="${isLtr ? "chevron-right" : "chevron-left"}"></sl-icon>
          </slot>
        </button>
      </nav>
    `;
    };
  }
  connectedCallback() {
    super.connectedCallback();
    this.setAttribute("role", "region");
    this.setAttribute("aria-roledescription", "carousel");
    const intersectionObserver = new IntersectionObserver(
      (entries) => {
        entries.forEach((entry) => {
          this.intersectionObserverEntries.set(entry.target, entry);
          const slide = entry.target;
          slide.toggleAttribute("inert", !entry.isIntersecting);
          slide.classList.toggle("--in-view", entry.isIntersecting);
          slide.setAttribute("aria-hidden", entry.isIntersecting ? "false" : "true");
        });
      },
      {
        root: this,
        threshold: 0.6
      }
    );
    this.intersectionObserver = intersectionObserver;
    intersectionObserver.takeRecords().forEach((entry) => {
      this.intersectionObserverEntries.set(entry.target, entry);
    });
  }
  disconnectedCallback() {
    super.disconnectedCallback();
    this.intersectionObserver.disconnect();
    this.mutationObserver.disconnect();
  }
  firstUpdated() {
    this.initializeSlides();
    this.mutationObserver = new MutationObserver(this.handleSlotChange.bind(this));
    this.mutationObserver.observe(this, { childList: true, subtree: false });
  }
  getSlides({ excludeClones = true } = {}) {
    return [...this.slides].filter((slide) => !excludeClones || !slide.hasAttribute("data-clone"));
  }
  /**
   * Move the carousel backward by `slides-per-move` slides.
   *
   * @param behavior - The behavior used for scrolling.
   */
  previous(behavior = "smooth") {
    this.goToSlide(this.activeSlide - this.slidesPerMove, behavior);
  }
  /**
   * Move the carousel forward by `slides-per-move` slides.
   *
   * @param behavior - The behavior used for scrolling.
   */
  next(behavior = "smooth") {
    this.goToSlide(this.activeSlide + this.slidesPerMove, behavior);
  }
  /**
   * Scrolls the carousel to the slide specified by `index`.
   *
   * @param index - The slide index.
   * @param behavior - The behavior used for scrolling.
   */
  goToSlide(index, behavior = "smooth") {
    const { slidesPerPage, loop } = this;
    const slidesWithClones = this.getSlides({ excludeClones: false });
    const normalizedIndex = clamp(index + (loop ? slidesPerPage : 0), 0, slidesWithClones.length - 1);
    const slide = slidesWithClones[normalizedIndex];
    this.scrollContainer.scrollTo({
      left: slide.offsetLeft,
      top: slide.offsetTop,
      behavior: prefersReducedMotion() ? "auto" : behavior
    });
  }
  handleSlotChange(mutations) {
    const needsInitialization = mutations.some(
      (mutation) => [...mutation.addedNodes, ...mutation.removedNodes].some(
        (node) => SlCarouselItem.isCarouselItem(node) && !node.hasAttribute("data-clone")
      )
    );
    if (needsInitialization) {
      this.initializeSlides();
      this.requestUpdate();
    }
  }
  handleScrollEnd() {
    const slides = this.getSlides();
    const entries = [...this.intersectionObserverEntries.values()];
    const firstIntersecting = entries.find((entry) => entry.isIntersecting);
    if (this.loop && (firstIntersecting == null ? void 0 : firstIntersecting.target.hasAttribute("data-clone"))) {
      const clonePosition = Number(firstIntersecting.target.getAttribute("data-clone"));
      this.goToSlide(clonePosition, "auto");
      return;
    }
    if (firstIntersecting) {
      this.activeSlide = slides.indexOf(firstIntersecting.target);
    }
  }
  initializeSlides() {
    const slides = this.getSlides();
    const intersectionObserver = this.intersectionObserver;
    this.intersectionObserverEntries.clear();
    this.getSlides({ excludeClones: false }).forEach((slide) => {
      intersectionObserver.unobserve(slide);
      slide.classList.remove("--in-view");
      slide.classList.remove("--is-active");
      if (slide.hasAttribute("data-clone")) {
        slide.remove();
      }
    });
    if (this.loop) {
      const slidesPerPage = this.slidesPerPage;
      const lastSlides = slides.slice(-slidesPerPage);
      const firstSlides = slides.slice(0, slidesPerPage);
      lastSlides.reverse().forEach((slide, i2) => {
        const clone = slide.cloneNode(true);
        clone.setAttribute("data-clone", String(slides.length - i2 - 1));
        this.prepend(clone);
      });
      firstSlides.forEach((slide, i2) => {
        const clone = slide.cloneNode(true);
        clone.setAttribute("data-clone", String(i2));
        this.append(clone);
      });
    }
    this.getSlides({ excludeClones: false }).forEach((slide) => {
      intersectionObserver.observe(slide);
    });
    this.goToSlide(this.activeSlide, "auto");
  }
  handelSlideChange() {
    const slides = this.getSlides();
    slides.forEach((slide, i2) => {
      slide.classList.toggle("--is-active", i2 === this.activeSlide);
    });
    if (this.hasUpdated) {
      this.emit("sl-slide-change", {
        detail: {
          index: this.activeSlide,
          slide: slides[this.activeSlide]
        }
      });
    }
  }
  handleSlidesPerMoveChange() {
    const slides = this.getSlides({ excludeClones: false });
    const slidesPerMove = this.slidesPerMove;
    slides.forEach((slide, i2) => {
      const shouldSnap = Math.abs(i2 - slidesPerMove) % slidesPerMove === 0;
      if (shouldSnap) {
        slide.style.removeProperty("scroll-snap-align");
      } else {
        slide.style.setProperty("scroll-snap-align", "none");
      }
    });
  }
  handleAutoplayChange() {
    this.autoplayController.stop();
    if (this.autoplay) {
      this.autoplayController.start(this.autoplayInterval);
    }
  }
  handleMouseDraggingChange() {
    this.scrollController.mouseDragging = this.mouseDragging;
  }
  render() {
    const { autoplayController, scrollController } = this;
    return y`
      <div part="base" class="carousel">
        <div
          id="scroll-container"
          part="scroll-container"
          class="${o({
      carousel__slides: true,
      "carousel__slides--horizontal": this.orientation === "horizontal",
      "carousel__slides--vertical": this.orientation === "vertical"
    })}"
          @scrollend="${this.handleScrollEnd}"
          role="list"
          tabindex="0"
          style="--slides-per-page: ${this.slidesPerPage};"
          aria-live="${!autoplayController.stopped && !autoplayController.paused ? "off" : "polite"}"
          aria-busy="${scrollController.scrolling ? "true" : "false"}"
          aria-atomic="true"
        >
          <slot></slot>
        </div>

        ${n(this.navigation, this.renderNavigation)} ${n(this.pagination, this.renderPagination)}
      </div>
    `;
  }
};
SlCarousel.styles = carousel_styles_default;
__decorateClass([
  e2({ type: Boolean, reflect: true })
], SlCarousel.prototype, "loop", 2);
__decorateClass([
  e2({ type: Boolean, reflect: true })
], SlCarousel.prototype, "navigation", 2);
__decorateClass([
  e2({ type: Boolean, reflect: true })
], SlCarousel.prototype, "pagination", 2);
__decorateClass([
  e2({ type: Boolean, reflect: true })
], SlCarousel.prototype, "autoplay", 2);
__decorateClass([
  e2({ type: Number, attribute: "autoplay-interval" })
], SlCarousel.prototype, "autoplayInterval", 2);
__decorateClass([
  e2({ type: Number, attribute: "slides-per-page" })
], SlCarousel.prototype, "slidesPerPage", 2);
__decorateClass([
  e2({ type: Number, attribute: "slides-per-move" })
], SlCarousel.prototype, "slidesPerMove", 2);
__decorateClass([
  e2()
], SlCarousel.prototype, "orientation", 2);
__decorateClass([
  e2({ type: Boolean, reflect: true, attribute: "mouse-dragging" })
], SlCarousel.prototype, "mouseDragging", 2);
__decorateClass([
  i("slot:not([name])")
], SlCarousel.prototype, "defaultSlot", 2);
__decorateClass([
  i(".carousel__slides")
], SlCarousel.prototype, "scrollContainer", 2);
__decorateClass([
  i(".carousel__pagination")
], SlCarousel.prototype, "paginationContainer", 2);
__decorateClass([
  t()
], SlCarousel.prototype, "activeSlide", 2);
__decorateClass([
  watch("loop", { waitUntilFirstUpdate: true }),
  watch("slidesPerPage", { waitUntilFirstUpdate: true })
], SlCarousel.prototype, "initializeSlides", 1);
__decorateClass([
  watch("activeSlide")
], SlCarousel.prototype, "handelSlideChange", 1);
__decorateClass([
  watch("slidesPerMove")
], SlCarousel.prototype, "handleSlidesPerMoveChange", 1);
__decorateClass([
  watch("autoplay")
], SlCarousel.prototype, "handleAutoplayChange", 1);
__decorateClass([
  watch("mouseDragging")
], SlCarousel.prototype, "handleMouseDraggingChange", 1);
SlCarousel = __decorateClass([
  e("sl-carousel")
], SlCarousel);

export {
  SlCarousel
};
/*! Bundled license information:

lit-html/directives/map.js:
  (**
   * @license
   * Copyright 2021 Google LLC
   * SPDX-License-Identifier: BSD-3-Clause
   *)

lit-html/directives/range.js:
  (**
   * @license
   * Copyright 2021 Google LLC
   * SPDX-License-Identifier: BSD-3-Clause
   *)
*/
