import '../icon/icon.js';
import ShoelaceElement from '../../internal/shoelace-element.js';
import type { CSSResultGroup } from 'lit';
import type { ShoelaceFormControl } from '../../internal/shoelace-element.js';
export default class SlInput extends ShoelaceElement implements ShoelaceFormControl {
    static styles: CSSResultGroup;
    private readonly formControlController;
    private readonly hasSlotController;
    private readonly localize;
    input: HTMLInputElement;
    private hasFocus;
    title: string;
    private __numberInput;
    private __dateInput;
    type: 'date' | 'datetime-local' | 'email' | 'number' | 'password' | 'search' | 'tel' | 'text' | 'time' | 'url';
    name: string;
    value: string;
    defaultValue: string;
    size: 'small' | 'medium' | 'large';
    filled: boolean;
    pill: boolean;
    label: string;
    helpText: string;
    clearable: boolean;
    disabled: boolean;
    placeholder: string;
    readonly: boolean;
    passwordToggle: boolean;
    passwordVisible: boolean;
    noSpinButtons: boolean;
    form: string;
    required: boolean;
    pattern: string;
    minlength: number;
    maxlength: number;
    min: number | string;
    max: number | string;
    step: number | 'any';
    autocapitalize: 'off' | 'none' | 'on' | 'sentences' | 'words' | 'characters';
    autocorrect: 'off' | 'on';
    autocomplete: string;
    autofocus: boolean;
    enterkeyhint: 'enter' | 'done' | 'go' | 'next' | 'previous' | 'search' | 'send';
    spellcheck: boolean;
    inputmode: 'none' | 'text' | 'decimal' | 'numeric' | 'tel' | 'search' | 'email' | 'url';
    get valueAsDate(): Date | null;
    set valueAsDate(newValue: Date | null);
    get valueAsNumber(): number;
    set valueAsNumber(newValue: number);
    get validity(): ValidityState;
    get validationMessage(): string;
    firstUpdated(): void;
    private handleBlur;
    private handleChange;
    private handleClearClick;
    private handleFocus;
    private handleInput;
    private handleInvalid;
    private handleKeyDown;
    private handlePasswordToggle;
    handleDisabledChange(): void;
    handleStepChange(): void;
    handleValueChange(): Promise<void>;
    focus(options?: FocusOptions): void;
    blur(): void;
    select(): void;
    setSelectionRange(selectionStart: number, selectionEnd: number, selectionDirection?: 'forward' | 'backward' | 'none'): void;
    setRangeText(replacement: string, start?: number, end?: number, selectMode?: 'select' | 'start' | 'end' | 'preserve'): void;
    showPicker(): void;
    stepUp(): void;
    stepDown(): void;
    checkValidity(): boolean;
    getForm(): HTMLFormElement | null;
    reportValidity(): boolean;
    setCustomValidity(message: string): void;
    render(): import("lit-html").TemplateResult<1>;
}
declare global {
    interface HTMLElementTagNameMap {
        'sl-input': SlInput;
    }
}
