import * as React from 'react';
import Component from '../../components/rating/rating.component.js';
import { type EventName } from '@lit-labs/react';
import type { SlChangeEvent } from '../../../src/events/events';
import type { SlHoverEvent } from '../../../src/events/events';
export type { SlChangeEvent } from '../../../src/events/events';
export type { SlHoverEvent } from '../../../src/events/events';
declare const component: import("@lit-labs/react").ReactWebComponent<Component, {
    onSlChange: EventName<SlChangeEvent>;
    onSlHover: EventName<SlHoverEvent>;
}>;
/**
 * @summary Ratings give users a way to quickly view and provide feedback.
 * @documentation https://shoelace.style/components/rating
 * @status stable
 * @since 2.0
 *
 * @dependency sl-icon
 *
 * @event sl-change - Emitted when the rating's value changes.
 * @event {{ phase: 'start' | 'move' | 'end', value: number }} sl-hover - Emitted when the user hovers over a value. The
 *  `phase` property indicates when hovering starts, moves to a new value, or ends. The `value` property tells what the
 *  rating's value would be if the user were to commit to the hovered value.
 *
 * @csspart base - The component's base wrapper.
 *
 * @cssproperty --symbol-color - The inactive color for symbols.
 * @cssproperty --symbol-color-active - The active color for symbols.
 * @cssproperty --symbol-size - The size of symbols.
 * @cssproperty --symbol-spacing - The spacing to use around symbols.
 */
declare class SlComponent extends React.Component<Parameters<typeof component>[0]> {
    constructor(...args: Parameters<typeof component>);
    render(): React.FunctionComponentElement<Partial<{
        slot?: string | undefined;
        style?: React.CSSProperties | undefined;
        title?: string | undefined;
        dir?: string | undefined;
        id?: string | undefined;
        accessKey?: string | undefined;
        draggable?: (boolean | "true" | "false") | undefined;
        hidden?: boolean | undefined;
        lang?: string | undefined;
        translate?: "yes" | "no" | undefined;
        className?: string | undefined;
        prefix?: string | undefined;
        role?: React.AriaRole | undefined;
        children?: React.ReactNode;
        contentEditable?: (boolean | "true" | "false") | "inherit" | undefined;
        inputMode?: "search" | "text" | "none" | "decimal" | "email" | "tel" | "url" | "numeric" | undefined;
        nonce?: string | undefined;
        tabIndex?: number | undefined;
        'aria-label'?: string | undefined;
        'aria-hidden'?: (boolean | "true" | "false") | undefined;
        'aria-current'?: boolean | "time" | "location" | "true" | "false" | "date" | "page" | "step" | undefined;
        defaultValue?: string | number | readonly string[] | undefined;
        'aria-roledescription'?: string | undefined;
        defaultChecked?: boolean | undefined;
        'aria-disabled'?: (boolean | "true" | "false") | undefined;
        'aria-checked'?: boolean | "true" | "false" | "mixed" | undefined;
        'aria-haspopup'?: boolean | "dialog" | "menu" | "true" | "false" | "listbox" | "tree" | "grid" | undefined;
        'aria-expanded'?: (boolean | "true" | "false") | undefined;
        placeholder?: string | undefined;
        color?: string | undefined;
        'aria-orientation'?: "horizontal" | "vertical" | undefined;
        'aria-selected'?: (boolean | "true" | "false") | undefined;
        'aria-labelledby'?: string | undefined;
        'aria-controls'?: string | undefined;
        'aria-busy'?: (boolean | "true" | "false") | undefined;
        'aria-multiselectable'?: (boolean | "true" | "false") | undefined;
        suppressContentEditableWarning?: boolean | undefined;
        suppressHydrationWarning?: boolean | undefined;
        contextMenu?: string | undefined;
        spellCheck?: (boolean | "true" | "false") | undefined;
        radioGroup?: string | undefined;
        about?: string | undefined;
        datatype?: string | undefined;
        inlist?: any;
        property?: string | undefined;
        resource?: string | undefined;
        typeof?: string | undefined;
        vocab?: string | undefined;
        autoCapitalize?: string | undefined;
        autoCorrect?: string | undefined;
        autoSave?: string | undefined;
        itemProp?: string | undefined;
        itemScope?: boolean | undefined;
        itemType?: string | undefined;
        itemID?: string | undefined;
        itemRef?: string | undefined;
        results?: number | undefined;
        security?: string | undefined;
        unselectable?: "off" | "on" | undefined;
        is?: string | undefined;
        'aria-activedescendant'?: string | undefined;
        'aria-atomic'?: (boolean | "true" | "false") | undefined;
        'aria-autocomplete'?: "both" | "none" | "inline" | "list" | undefined;
        'aria-colcount'?: number | undefined;
        'aria-colindex'?: number | undefined;
        'aria-colspan'?: number | undefined;
        'aria-describedby'?: string | undefined;
        'aria-details'?: string | undefined;
        'aria-dropeffect'?: "link" | "none" | "copy" | "move" | "popup" | "execute" | undefined;
        'aria-errormessage'?: string | undefined;
        'aria-flowto'?: string | undefined;
        'aria-grabbed'?: (boolean | "true" | "false") | undefined;
        'aria-invalid'?: boolean | "true" | "false" | "grammar" | "spelling" | undefined;
        'aria-keyshortcuts'?: string | undefined;
        'aria-level'?: number | undefined;
        'aria-live'?: "off" | "polite" | "assertive" | undefined;
        'aria-modal'?: (boolean | "true" | "false") | undefined;
        'aria-multiline'?: (boolean | "true" | "false") | undefined;
        'aria-owns'?: string | undefined;
        'aria-placeholder'?: string | undefined;
        'aria-posinset'?: number | undefined;
        'aria-pressed'?: boolean | "true" | "false" | "mixed" | undefined;
        'aria-readonly'?: (boolean | "true" | "false") | undefined;
        'aria-relevant'?: "text" | "additions" | "additions removals" | "additions text" | "all" | "removals" | "removals additions" | "removals text" | "text additions" | "text removals" | undefined;
        'aria-required'?: (boolean | "true" | "false") | undefined;
        'aria-rowcount'?: number | undefined;
        'aria-rowindex'?: number | undefined;
        'aria-rowspan'?: number | undefined;
        'aria-setsize'?: number | undefined;
        'aria-sort'?: "none" | "ascending" | "descending" | "other" | undefined;
        'aria-valuemax'?: number | undefined;
        'aria-valuemin'?: number | undefined;
        'aria-valuenow'?: number | undefined;
        'aria-valuetext'?: string | undefined;
        dangerouslySetInnerHTML?: {
            __html: string;
        } | undefined;
        onCopy?: React.ClipboardEventHandler<Component> | undefined;
        onCopyCapture?: React.ClipboardEventHandler<Component> | undefined;
        onCut?: React.ClipboardEventHandler<Component> | undefined;
        onCutCapture?: React.ClipboardEventHandler<Component> | undefined;
        onPaste?: React.ClipboardEventHandler<Component> | undefined;
        onPasteCapture?: React.ClipboardEventHandler<Component> | undefined;
        onCompositionEnd?: React.CompositionEventHandler<Component> | undefined;
        onCompositionEndCapture?: React.CompositionEventHandler<Component> | undefined;
        onCompositionStart?: React.CompositionEventHandler<Component> | undefined;
        onCompositionStartCapture?: React.CompositionEventHandler<Component> | undefined;
        onCompositionUpdate?: React.CompositionEventHandler<Component> | undefined;
        onCompositionUpdateCapture?: React.CompositionEventHandler<Component> | undefined;
        onFocus?: React.FocusEventHandler<Component> | undefined;
        onFocusCapture?: React.FocusEventHandler<Component> | undefined;
        onBlur?: React.FocusEventHandler<Component> | undefined;
        onBlurCapture?: React.FocusEventHandler<Component> | undefined;
        onChange?: React.FormEventHandler<Component> | undefined;
        onChangeCapture?: React.FormEventHandler<Component> | undefined;
        onBeforeInput?: React.FormEventHandler<Component> | undefined;
        onBeforeInputCapture?: React.FormEventHandler<Component> | undefined;
        onInput?: React.FormEventHandler<Component> | undefined;
        onInputCapture?: React.FormEventHandler<Component> | undefined;
        onReset?: React.FormEventHandler<Component> | undefined;
        onResetCapture?: React.FormEventHandler<Component> | undefined;
        onSubmit?: React.FormEventHandler<Component> | undefined;
        onSubmitCapture?: React.FormEventHandler<Component> | undefined;
        onInvalid?: React.FormEventHandler<Component> | undefined;
        onInvalidCapture?: React.FormEventHandler<Component> | undefined;
        onLoad?: React.ReactEventHandler<Component> | undefined;
        onLoadCapture?: React.ReactEventHandler<Component> | undefined;
        onError?: React.ReactEventHandler<Component> | undefined;
        onErrorCapture?: React.ReactEventHandler<Component> | undefined;
        onKeyDown?: React.KeyboardEventHandler<Component> | undefined;
        onKeyDownCapture?: React.KeyboardEventHandler<Component> | undefined;
        onKeyPress?: React.KeyboardEventHandler<Component> | undefined;
        onKeyPressCapture?: React.KeyboardEventHandler<Component> | undefined;
        onKeyUp?: React.KeyboardEventHandler<Component> | undefined;
        onKeyUpCapture?: React.KeyboardEventHandler<Component> | undefined;
        onAbort?: React.ReactEventHandler<Component> | undefined;
        onAbortCapture?: React.ReactEventHandler<Component> | undefined;
        onCanPlay?: React.ReactEventHandler<Component> | undefined;
        onCanPlayCapture?: React.ReactEventHandler<Component> | undefined;
        onCanPlayThrough?: React.ReactEventHandler<Component> | undefined;
        onCanPlayThroughCapture?: React.ReactEventHandler<Component> | undefined;
        onDurationChange?: React.ReactEventHandler<Component> | undefined;
        onDurationChangeCapture?: React.ReactEventHandler<Component> | undefined;
        onEmptied?: React.ReactEventHandler<Component> | undefined;
        onEmptiedCapture?: React.ReactEventHandler<Component> | undefined;
        onEncrypted?: React.ReactEventHandler<Component> | undefined;
        onEncryptedCapture?: React.ReactEventHandler<Component> | undefined;
        onEnded?: React.ReactEventHandler<Component> | undefined;
        onEndedCapture?: React.ReactEventHandler<Component> | undefined;
        onLoadedData?: React.ReactEventHandler<Component> | undefined;
        onLoadedDataCapture?: React.ReactEventHandler<Component> | undefined;
        onLoadedMetadata?: React.ReactEventHandler<Component> | undefined;
        onLoadedMetadataCapture?: React.ReactEventHandler<Component> | undefined;
        onLoadStart?: React.ReactEventHandler<Component> | undefined;
        onLoadStartCapture?: React.ReactEventHandler<Component> | undefined;
        onPause?: React.ReactEventHandler<Component> | undefined;
        onPauseCapture?: React.ReactEventHandler<Component> | undefined;
        onPlay?: React.ReactEventHandler<Component> | undefined;
        onPlayCapture?: React.ReactEventHandler<Component> | undefined;
        onPlaying?: React.ReactEventHandler<Component> | undefined;
        onPlayingCapture?: React.ReactEventHandler<Component> | undefined;
        onProgress?: React.ReactEventHandler<Component> | undefined;
        onProgressCapture?: React.ReactEventHandler<Component> | undefined;
        onRateChange?: React.ReactEventHandler<Component> | undefined;
        onRateChangeCapture?: React.ReactEventHandler<Component> | undefined;
        onResize?: React.ReactEventHandler<Component> | undefined;
        onResizeCapture?: React.ReactEventHandler<Component> | undefined;
        onSeeked?: React.ReactEventHandler<Component> | undefined;
        onSeekedCapture?: React.ReactEventHandler<Component> | undefined;
        onSeeking?: React.ReactEventHandler<Component> | undefined;
        onSeekingCapture?: React.ReactEventHandler<Component> | undefined;
        onStalled?: React.ReactEventHandler<Component> | undefined;
        onStalledCapture?: React.ReactEventHandler<Component> | undefined;
        onSuspend?: React.ReactEventHandler<Component> | undefined;
        onSuspendCapture?: React.ReactEventHandler<Component> | undefined;
        onTimeUpdate?: React.ReactEventHandler<Component> | undefined;
        onTimeUpdateCapture?: React.ReactEventHandler<Component> | undefined;
        onVolumeChange?: React.ReactEventHandler<Component> | undefined;
        onVolumeChangeCapture?: React.ReactEventHandler<Component> | undefined;
        onWaiting?: React.ReactEventHandler<Component> | undefined;
        onWaitingCapture?: React.ReactEventHandler<Component> | undefined;
        onAuxClick?: React.MouseEventHandler<Component> | undefined;
        onAuxClickCapture?: React.MouseEventHandler<Component> | undefined;
        onClick?: React.MouseEventHandler<Component> | undefined;
        onClickCapture?: React.MouseEventHandler<Component> | undefined;
        onContextMenu?: React.MouseEventHandler<Component> | undefined;
        onContextMenuCapture?: React.MouseEventHandler<Component> | undefined;
        onDoubleClick?: React.MouseEventHandler<Component> | undefined;
        onDoubleClickCapture?: React.MouseEventHandler<Component> | undefined;
        onDrag?: React.DragEventHandler<Component> | undefined;
        onDragCapture?: React.DragEventHandler<Component> | undefined;
        onDragEnd?: React.DragEventHandler<Component> | undefined;
        onDragEndCapture?: React.DragEventHandler<Component> | undefined;
        onDragEnter?: React.DragEventHandler<Component> | undefined;
        onDragEnterCapture?: React.DragEventHandler<Component> | undefined;
        onDragExit?: React.DragEventHandler<Component> | undefined;
        onDragExitCapture?: React.DragEventHandler<Component> | undefined;
        onDragLeave?: React.DragEventHandler<Component> | undefined;
        onDragLeaveCapture?: React.DragEventHandler<Component> | undefined;
        onDragOver?: React.DragEventHandler<Component> | undefined;
        onDragOverCapture?: React.DragEventHandler<Component> | undefined;
        onDragStart?: React.DragEventHandler<Component> | undefined;
        onDragStartCapture?: React.DragEventHandler<Component> | undefined;
        onDrop?: React.DragEventHandler<Component> | undefined;
        onDropCapture?: React.DragEventHandler<Component> | undefined;
        onMouseDown?: React.MouseEventHandler<Component> | undefined;
        onMouseDownCapture?: React.MouseEventHandler<Component> | undefined;
        onMouseEnter?: React.MouseEventHandler<Component> | undefined;
        onMouseLeave?: React.MouseEventHandler<Component> | undefined;
        onMouseMove?: React.MouseEventHandler<Component> | undefined;
        onMouseMoveCapture?: React.MouseEventHandler<Component> | undefined;
        onMouseOut?: React.MouseEventHandler<Component> | undefined;
        onMouseOutCapture?: React.MouseEventHandler<Component> | undefined;
        onMouseOver?: React.MouseEventHandler<Component> | undefined;
        onMouseOverCapture?: React.MouseEventHandler<Component> | undefined;
        onMouseUp?: React.MouseEventHandler<Component> | undefined;
        onMouseUpCapture?: React.MouseEventHandler<Component> | undefined;
        onSelect?: React.ReactEventHandler<Component> | undefined;
        onSelectCapture?: React.ReactEventHandler<Component> | undefined;
        onTouchCancel?: React.TouchEventHandler<Component> | undefined;
        onTouchCancelCapture?: React.TouchEventHandler<Component> | undefined;
        onTouchEnd?: React.TouchEventHandler<Component> | undefined;
        onTouchEndCapture?: React.TouchEventHandler<Component> | undefined;
        onTouchMove?: React.TouchEventHandler<Component> | undefined;
        onTouchMoveCapture?: React.TouchEventHandler<Component> | undefined;
        onTouchStart?: React.TouchEventHandler<Component> | undefined;
        onTouchStartCapture?: React.TouchEventHandler<Component> | undefined;
        onPointerDown?: React.PointerEventHandler<Component> | undefined;
        onPointerDownCapture?: React.PointerEventHandler<Component> | undefined;
        onPointerMove?: React.PointerEventHandler<Component> | undefined;
        onPointerMoveCapture?: React.PointerEventHandler<Component> | undefined;
        onPointerUp?: React.PointerEventHandler<Component> | undefined;
        onPointerUpCapture?: React.PointerEventHandler<Component> | undefined;
        onPointerCancel?: React.PointerEventHandler<Component> | undefined;
        onPointerCancelCapture?: React.PointerEventHandler<Component> | undefined;
        onPointerEnter?: React.PointerEventHandler<Component> | undefined;
        onPointerEnterCapture?: React.PointerEventHandler<Component> | undefined;
        onPointerLeave?: React.PointerEventHandler<Component> | undefined;
        onPointerLeaveCapture?: React.PointerEventHandler<Component> | undefined;
        onPointerOver?: React.PointerEventHandler<Component> | undefined;
        onPointerOverCapture?: React.PointerEventHandler<Component> | undefined;
        onPointerOut?: React.PointerEventHandler<Component> | undefined;
        onPointerOutCapture?: React.PointerEventHandler<Component> | undefined;
        onGotPointerCapture?: React.PointerEventHandler<Component> | undefined;
        onGotPointerCaptureCapture?: React.PointerEventHandler<Component> | undefined;
        onLostPointerCapture?: React.PointerEventHandler<Component> | undefined;
        onLostPointerCaptureCapture?: React.PointerEventHandler<Component> | undefined;
        onScroll?: React.UIEventHandler<Component> | undefined;
        onScrollCapture?: React.UIEventHandler<Component> | undefined;
        onWheel?: React.WheelEventHandler<Component> | undefined;
        onWheelCapture?: React.WheelEventHandler<Component> | undefined;
        onAnimationStart?: React.AnimationEventHandler<Component> | undefined;
        onAnimationStartCapture?: React.AnimationEventHandler<Component> | undefined;
        onAnimationEnd?: React.AnimationEventHandler<Component> | undefined;
        onAnimationEndCapture?: React.AnimationEventHandler<Component> | undefined;
        onAnimationIteration?: React.AnimationEventHandler<Component> | undefined;
        onAnimationIterationCapture?: React.AnimationEventHandler<Component> | undefined;
        onTransitionEnd?: React.TransitionEventHandler<Component> | undefined;
        onTransitionEndCapture?: React.TransitionEventHandler<Component> | undefined;
    } & {
        label: string;
        animate: (keyframes: Keyframe[] | PropertyIndexedKeyframes | null, options?: number | KeyframeAnimationOptions | undefined) => Animation;
        remove: () => void;
        blur: () => void;
        click: () => void;
        focus: (options?: FocusOptions | undefined) => void;
        scroll: {
            (options?: ScrollToOptions | undefined): void;
            (x: number, y: number): void;
        };
        readonly renderOptions: import("lit-html").RenderOptions;
        connectedCallback: () => void;
        disconnectedCallback: () => void;
        readonly renderRoot: HTMLElement | ShadowRoot;
        isUpdatePending: boolean;
        hasUpdated: boolean;
        addController: (controller: import("lit").ReactiveController) => void;
        removeController: (controller: import("lit").ReactiveController) => void;
        attributeChangedCallback: (name: string, _old: string | null, value: string | null) => void;
        requestUpdate: (name?: PropertyKey | undefined, oldValue?: unknown, options?: import("lit").PropertyDeclaration<unknown, unknown> | undefined) => void;
        readonly updateComplete: Promise<boolean>;
        readonly accessKeyLabel: string;
        autocapitalize: string;
        inert: boolean;
        innerText: string;
        readonly offsetHeight: number;
        readonly offsetLeft: number;
        readonly offsetParent: Element | null;
        readonly offsetTop: number;
        readonly offsetWidth: number;
        outerText: string;
        spellcheck: boolean;
        attachInternals: () => ElementInternals;
        addEventListener: {
            <K extends keyof HTMLElementEventMap>(type: K, listener: (this: HTMLElement, ev: HTMLElementEventMap[K]) => any, options?: boolean | AddEventListenerOptions | undefined): void;
            (type: string, listener: EventListenerOrEventListenerObject, options?: boolean | AddEventListenerOptions | undefined): void;
        };
        removeEventListener: {
            <K_1 extends keyof HTMLElementEventMap>(type: K_1, listener: (this: HTMLElement, ev: HTMLElementEventMap[K_1]) => any, options?: boolean | EventListenerOptions | undefined): void;
            (type: string, listener: EventListenerOrEventListenerObject, options?: boolean | EventListenerOptions | undefined): void;
        };
        readonly attributes: NamedNodeMap;
        readonly classList: DOMTokenList;
        readonly clientHeight: number;
        readonly clientLeft: number;
        readonly clientTop: number;
        readonly clientWidth: number;
        readonly localName: string;
        readonly namespaceURI: string | null;
        onfullscreenchange: ((this: Element, ev: Event) => any) | null;
        onfullscreenerror: ((this: Element, ev: Event) => any) | null;
        outerHTML: string;
        readonly ownerDocument: Document;
        readonly part: DOMTokenList;
        readonly scrollHeight: number;
        scrollLeft: number;
        scrollTop: number;
        readonly scrollWidth: number;
        readonly shadowRoot: ShadowRoot | null;
        readonly tagName: string;
        attachShadow: (init: ShadowRootInit) => ShadowRoot;
        checkVisibility: (options?: CheckVisibilityOptions | undefined) => boolean;
        closest: {
            <K_2 extends keyof HTMLElementTagNameMap>(selector: K_2): HTMLElementTagNameMap[K_2] | null;
            <K_3 extends keyof SVGElementTagNameMap>(selector: K_3): SVGElementTagNameMap[K_3] | null;
            <K_4 extends keyof MathMLElementTagNameMap>(selector: K_4): MathMLElementTagNameMap[K_4] | null;
            <E extends Element = Element>(selectors: string): E | null;
        };
        computedStyleMap: () => StylePropertyMapReadOnly;
        getAttribute: (qualifiedName: string) => string | null;
        getAttributeNS: (namespace: string | null, localName: string) => string | null;
        getAttributeNames: () => string[];
        getAttributeNode: (qualifiedName: string) => Attr | null;
        getAttributeNodeNS: (namespace: string | null, localName: string) => Attr | null;
        getBoundingClientRect: () => DOMRect;
        getClientRects: () => DOMRectList;
        getElementsByClassName: (classNames: string) => HTMLCollectionOf<Element>;
        getElementsByTagName: {
            <K_5 extends keyof HTMLElementTagNameMap>(qualifiedName: K_5): HTMLCollectionOf<HTMLElementTagNameMap[K_5]>;
            <K_6 extends keyof SVGElementTagNameMap>(qualifiedName: K_6): HTMLCollectionOf<SVGElementTagNameMap[K_6]>;
            <K_7 extends keyof MathMLElementTagNameMap>(qualifiedName: K_7): HTMLCollectionOf<MathMLElementTagNameMap[K_7]>;
            <K_8 extends keyof HTMLElementDeprecatedTagNameMap>(qualifiedName: K_8): HTMLCollectionOf<HTMLElementDeprecatedTagNameMap[K_8]>;
            (qualifiedName: string): HTMLCollectionOf<Element>;
        };
        getElementsByTagNameNS: {
            (namespaceURI: "http://www.w3.org/1999/xhtml", localName: string): HTMLCollectionOf<HTMLElement>;
            (namespaceURI: "http://www.w3.org/2000/svg", localName: string): HTMLCollectionOf<SVGElement>;
            (namespaceURI: "http://www.w3.org/1998/Math/MathML", localName: string): HTMLCollectionOf<MathMLElement>;
            (namespace: string | null, localName: string): HTMLCollectionOf<Element>;
        };
        hasAttribute: (qualifiedName: string) => boolean;
        hasAttributeNS: (namespace: string | null, localName: string) => boolean;
        hasAttributes: () => boolean;
        hasPointerCapture: (pointerId: number) => boolean;
        insertAdjacentElement: (where: InsertPosition, element: Element) => Element | null;
        insertAdjacentHTML: (position: InsertPosition, text: string) => void;
        insertAdjacentText: (where: InsertPosition, data: string) => void;
        matches: (selectors: string) => boolean;
        releasePointerCapture: (pointerId: number) => void;
        removeAttribute: (qualifiedName: string) => void;
        removeAttributeNS: (namespace: string | null, localName: string) => void;
        removeAttributeNode: (attr: Attr) => Attr;
        requestFullscreen: (options?: FullscreenOptions | undefined) => Promise<void>;
        requestPointerLock: () => void;
        scrollBy: {
            (options?: ScrollToOptions | undefined): void;
            (x: number, y: number): void;
        };
        scrollIntoView: (arg?: boolean | ScrollIntoViewOptions | undefined) => void;
        scrollTo: {
            (options?: ScrollToOptions | undefined): void;
            (x: number, y: number): void;
        };
        setAttribute: (qualifiedName: string, value: string) => void;
        setAttributeNS: (namespace: string | null, qualifiedName: string, value: string) => void;
        setAttributeNode: (attr: Attr) => Attr | null;
        setAttributeNodeNS: (attr: Attr) => Attr | null;
        setPointerCapture: (pointerId: number) => void;
        toggleAttribute: (qualifiedName: string, force?: boolean | undefined) => boolean;
        webkitMatchesSelector: (selectors: string) => boolean;
        readonly baseURI: string;
        readonly childNodes: NodeListOf<ChildNode>;
        readonly firstChild: ChildNode | null;
        readonly isConnected: boolean;
        readonly lastChild: ChildNode | null;
        readonly nextSibling: ChildNode | null;
        readonly nodeName: string;
        readonly nodeType: number;
        nodeValue: string | null;
        readonly parentElement: HTMLElement | null;
        readonly parentNode: ParentNode | null;
        readonly previousSibling: ChildNode | null;
        textContent: string | null;
        appendChild: <T extends Node>(node: T) => T;
        cloneNode: (deep?: boolean | undefined) => Node;
        compareDocumentPosition: (other: Node) => number;
        contains: (other: Node | null) => boolean;
        getRootNode: (options?: GetRootNodeOptions | undefined) => Node;
        hasChildNodes: () => boolean;
        insertBefore: <T_1 extends Node>(node: T_1, child: Node | null) => T_1;
        isDefaultNamespace: (namespace: string | null) => boolean;
        isEqualNode: (otherNode: Node | null) => boolean;
        isSameNode: (otherNode: Node | null) => boolean;
        lookupNamespaceURI: (prefix: string | null) => string | null;
        lookupPrefix: (namespace: string | null) => string | null;
        normalize: () => void;
        removeChild: <T_2 extends Node>(child: T_2) => T_2;
        replaceChild: <T_3 extends Node>(node: Node, child: T_3) => T_3;
        readonly ELEMENT_NODE: 1;
        readonly ATTRIBUTE_NODE: 2;
        readonly TEXT_NODE: 3;
        readonly CDATA_SECTION_NODE: 4;
        readonly ENTITY_REFERENCE_NODE: 5;
        readonly ENTITY_NODE: 6;
        readonly PROCESSING_INSTRUCTION_NODE: 7;
        readonly COMMENT_NODE: 8;
        readonly DOCUMENT_NODE: 9;
        readonly DOCUMENT_TYPE_NODE: 10;
        readonly DOCUMENT_FRAGMENT_NODE: 11;
        readonly NOTATION_NODE: 12;
        readonly DOCUMENT_POSITION_DISCONNECTED: 1;
        readonly DOCUMENT_POSITION_PRECEDING: 2;
        readonly DOCUMENT_POSITION_FOLLOWING: 4;
        readonly DOCUMENT_POSITION_CONTAINS: 8;
        readonly DOCUMENT_POSITION_CONTAINED_BY: 16;
        readonly DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC: 32;
        dispatchEvent: (event: Event) => boolean;
        ariaAtomic: string | null;
        ariaAutoComplete: string | null;
        ariaBusy: string | null;
        ariaChecked: string | null;
        ariaColCount: string | null;
        ariaColIndex: string | null;
        ariaColSpan: string | null;
        ariaCurrent: string | null;
        ariaDisabled: string | null;
        ariaExpanded: string | null;
        ariaHasPopup: string | null;
        ariaHidden: string | null;
        ariaInvalid: string | null;
        ariaKeyShortcuts: string | null;
        ariaLabel: string | null;
        ariaLevel: string | null;
        ariaLive: string | null;
        ariaModal: string | null;
        ariaMultiLine: string | null;
        ariaMultiSelectable: string | null;
        ariaOrientation: string | null;
        ariaPlaceholder: string | null;
        ariaPosInSet: string | null;
        ariaPressed: string | null;
        ariaReadOnly: string | null;
        ariaRequired: string | null;
        ariaRoleDescription: string | null;
        ariaRowCount: string | null;
        ariaRowIndex: string | null;
        ariaRowSpan: string | null;
        ariaSelected: string | null;
        ariaSetSize: string | null;
        ariaSort: string | null;
        ariaValueMax: string | null;
        ariaValueMin: string | null;
        ariaValueNow: string | null;
        ariaValueText: string | null;
        getAnimations: (options?: GetAnimationsOptions | undefined) => Animation[];
        after: (...nodes: (string | Node)[]) => void;
        before: (...nodes: (string | Node)[]) => void;
        replaceWith: (...nodes: (string | Node)[]) => void;
        innerHTML: string;
        readonly nextElementSibling: Element | null;
        readonly previousElementSibling: Element | null;
        readonly childElementCount: number;
        readonly firstElementChild: Element | null;
        readonly lastElementChild: Element | null;
        append: (...nodes: (string | Node)[]) => void;
        prepend: (...nodes: (string | Node)[]) => void;
        querySelector: {
            <K_9 extends keyof HTMLElementTagNameMap>(selectors: K_9): HTMLElementTagNameMap[K_9] | null;
            <K_10 extends keyof SVGElementTagNameMap>(selectors: K_10): SVGElementTagNameMap[K_10] | null;
            <K_11 extends keyof MathMLElementTagNameMap>(selectors: K_11): MathMLElementTagNameMap[K_11] | null;
            <K_12 extends keyof HTMLElementDeprecatedTagNameMap>(selectors: K_12): HTMLElementDeprecatedTagNameMap[K_12] | null;
            <E_1 extends Element = Element>(selectors: string): E_1 | null;
        };
        querySelectorAll: {
            <K_13 extends keyof HTMLElementTagNameMap>(selectors: K_13): NodeListOf<HTMLElementTagNameMap[K_13]>;
            <K_14 extends keyof SVGElementTagNameMap>(selectors: K_14): NodeListOf<SVGElementTagNameMap[K_14]>;
            <K_15 extends keyof MathMLElementTagNameMap>(selectors: K_15): NodeListOf<MathMLElementTagNameMap[K_15]>;
            <K_16 extends keyof HTMLElementDeprecatedTagNameMap>(selectors: K_16): NodeListOf<HTMLElementDeprecatedTagNameMap[K_16]>;
            <E_2 extends Element = Element>(selectors: string): NodeListOf<E_2>;
        };
        replaceChildren: (...nodes: (string | Node)[]) => void;
        readonly assignedSlot: HTMLSlotElement | null;
        readonly attributeStyleMap: StylePropertyMap;
        enterKeyHint: string;
        readonly isContentEditable: boolean;
        onabort: ((this: GlobalEventHandlers, ev: UIEvent) => any) | null;
        onanimationcancel: ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null;
        onanimationend: ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null;
        onanimationiteration: ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null;
        onanimationstart: ((this: GlobalEventHandlers, ev: AnimationEvent) => any) | null;
        onauxclick: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;
        onbeforeinput: ((this: GlobalEventHandlers, ev: InputEvent) => any) | null;
        onblur: ((this: GlobalEventHandlers, ev: FocusEvent) => any) | null;
        oncancel: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        oncanplay: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        oncanplaythrough: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        onchange: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        onclick: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;
        onclose: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        oncontextmenu: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;
        oncopy: ((this: GlobalEventHandlers, ev: ClipboardEvent) => any) | null;
        oncuechange: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        oncut: ((this: GlobalEventHandlers, ev: ClipboardEvent) => any) | null;
        ondblclick: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;
        ondrag: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;
        ondragend: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;
        ondragenter: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;
        ondragleave: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;
        ondragover: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;
        ondragstart: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;
        ondrop: ((this: GlobalEventHandlers, ev: DragEvent) => any) | null;
        ondurationchange: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        onemptied: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        onended: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        onerror: OnErrorEventHandler;
        onfocus: ((this: GlobalEventHandlers, ev: FocusEvent) => any) | null;
        onformdata: ((this: GlobalEventHandlers, ev: FormDataEvent) => any) | null;
        ongotpointercapture: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;
        oninput: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        oninvalid: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        onkeydown: ((this: GlobalEventHandlers, ev: KeyboardEvent) => any) | null;
        onkeypress: ((this: GlobalEventHandlers, ev: KeyboardEvent) => any) | null;
        onkeyup: ((this: GlobalEventHandlers, ev: KeyboardEvent) => any) | null;
        onload: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        onloadeddata: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        onloadedmetadata: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        onloadstart: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        onlostpointercapture: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;
        onmousedown: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;
        onmouseenter: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;
        onmouseleave: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;
        onmousemove: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;
        onmouseout: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;
        onmouseover: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;
        onmouseup: ((this: GlobalEventHandlers, ev: MouseEvent) => any) | null;
        onpaste: ((this: GlobalEventHandlers, ev: ClipboardEvent) => any) | null;
        onpause: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        onplay: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        onplaying: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        onpointercancel: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;
        onpointerdown: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;
        onpointerenter: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;
        onpointerleave: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;
        onpointermove: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;
        onpointerout: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;
        onpointerover: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;
        onpointerup: ((this: GlobalEventHandlers, ev: PointerEvent) => any) | null;
        onprogress: ((this: GlobalEventHandlers, ev: ProgressEvent<EventTarget>) => any) | null;
        onratechange: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        onreset: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        onresize: ((this: GlobalEventHandlers, ev: UIEvent) => any) | null;
        onscroll: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        onsecuritypolicyviolation: ((this: GlobalEventHandlers, ev: SecurityPolicyViolationEvent) => any) | null;
        onseeked: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        onseeking: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        onselect: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        onselectionchange: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        onselectstart: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        onslotchange: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        onstalled: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        onsubmit: ((this: GlobalEventHandlers, ev: SubmitEvent) => any) | null;
        onsuspend: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        ontimeupdate: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        ontoggle: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        ontouchcancel?: ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null | undefined;
        ontouchend?: ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null | undefined;
        ontouchmove?: ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null | undefined;
        ontouchstart?: ((this: GlobalEventHandlers, ev: TouchEvent) => any) | null | undefined;
        ontransitioncancel: ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null;
        ontransitionend: ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null;
        ontransitionrun: ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null;
        ontransitionstart: ((this: GlobalEventHandlers, ev: TransitionEvent) => any) | null;
        onvolumechange: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        onwaiting: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        onwebkitanimationend: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        onwebkitanimationiteration: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        onwebkitanimationstart: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        onwebkittransitionend: ((this: GlobalEventHandlers, ev: Event) => any) | null;
        onwheel: ((this: GlobalEventHandlers, ev: WheelEvent) => any) | null;
        autofocus: boolean;
        readonly dataset: DOMStringMap;
        value: number;
        render: () => import("lit-html").TemplateResult<1>;
        emit: {
            <T_4 extends "input" | "progress" | "select" | "sl-input" | "cancel" | "slotchange" | "abort" | "animationcancel" | "animationend" | "animationiteration" | "animationstart" | "auxclick" | "beforeinput" | "blur" | "canplay" | "canplaythrough" | "change" | "click" | "close" | "compositionend" | "compositionstart" | "compositionupdate" | "contextmenu" | "copy" | "cuechange" | "cut" | "dblclick" | "drag" | "dragend" | "dragenter" | "dragleave" | "dragover" | "dragstart" | "drop" | "durationchange" | "emptied" | "ended" | "error" | "focus" | "focusin" | "focusout" | "formdata" | "gotpointercapture" | "invalid" | "keydown" | "keypress" | "keyup" | "load" | "loadeddata" | "loadedmetadata" | "loadstart" | "lostpointercapture" | "mousedown" | "mouseenter" | "mouseleave" | "mousemove" | "mouseout" | "mouseover" | "mouseup" | "paste" | "pause" | "play" | "playing" | "pointercancel" | "pointerdown" | "pointerenter" | "pointerleave" | "pointermove" | "pointerout" | "pointerover" | "pointerup" | "ratechange" | "reset" | "resize" | "scroll" | "securitypolicyviolation" | "seeked" | "seeking" | "selectionchange" | "selectstart" | "stalled" | "submit" | "suspend" | "timeupdate" | "toggle" | "touchcancel" | "touchend" | "touchmove" | "touchstart" | "transitioncancel" | "transitionend" | "transitionrun" | "transitionstart" | "volumechange" | "waiting" | "webkitanimationend" | "webkitanimationiteration" | "webkitanimationstart" | "webkittransitionend" | "wheel" | "sl-change" | "sl-remove" | "sl-after-collapse" | "sl-after-expand" | "sl-after-hide" | "sl-after-show" | "sl-blur" | "sl-cancel" | "sl-clear" | "sl-close" | "sl-collapse" | "sl-error" | "sl-expand" | "sl-finish" | "sl-focus" | "sl-hide" | "sl-initial-focus" | "sl-invalid" | "sl-lazy-change" | "sl-lazy-load" | "sl-load" | "sl-reposition" | "sl-show" | "sl-start">(name: T_4 extends keyof GlobalEventHandlersEventMap ? GlobalEventHandlersEventMap[T_4] extends CustomEvent<Record<PropertyKey, unknown>> ? GlobalEventHandlersEventMap[T_4] extends CustomEvent<Record<PropertyKey, never>> ? T_4 : Partial<GlobalEventHandlersEventMap[T_4]["detail"]> extends GlobalEventHandlersEventMap[T_4]["detail"] ? T_4 : never : T_4 : T_4, options?: (T_4 extends keyof GlobalEventHandlersEventMap ? GlobalEventHandlersEventMap[T_4] extends CustomEvent<Record<PropertyKey, unknown>> ? GlobalEventHandlersEventMap[T_4] extends CustomEvent<Record<PropertyKey, never>> ? CustomEventInit<GlobalEventHandlersEventMap[T_4]["detail"]> : Partial<GlobalEventHandlersEventMap[T_4]["detail"]> extends GlobalEventHandlersEventMap[T_4]["detail"] ? CustomEventInit<GlobalEventHandlersEventMap[T_4]["detail"]> : CustomEventInit<GlobalEventHandlersEventMap[T_4]["detail"]> & {
                detail: GlobalEventHandlersEventMap[T_4]["detail"];
            } : CustomEventInit<any> : CustomEventInit<any>) | undefined): T_4 extends keyof GlobalEventHandlersEventMap ? GlobalEventHandlersEventMap[T_4] extends CustomEvent<unknown> ? GlobalEventHandlersEventMap[T_4] : CustomEvent<unknown> : CustomEvent<unknown>;
            <T_5 extends "sl-select" | "sl-copy" | "sl-hover" | "sl-mutation" | "sl-request-close" | "sl-resize" | "sl-selection-change" | "sl-slide-change" | "sl-tab-hide" | "sl-tab-show">(name: T_5 extends keyof GlobalEventHandlersEventMap ? GlobalEventHandlersEventMap[T_5] extends CustomEvent<Record<PropertyKey, unknown>> ? GlobalEventHandlersEventMap[T_5] extends CustomEvent<Record<PropertyKey, never>> ? never : Partial<GlobalEventHandlersEventMap[T_5]["detail"]> extends GlobalEventHandlersEventMap[T_5]["detail"] ? never : T_5 : never : never, options: T_5 extends keyof GlobalEventHandlersEventMap ? GlobalEventHandlersEventMap[T_5] extends CustomEvent<Record<PropertyKey, unknown>> ? GlobalEventHandlersEventMap[T_5] extends CustomEvent<Record<PropertyKey, never>> ? CustomEventInit<GlobalEventHandlersEventMap[T_5]["detail"]> : Partial<GlobalEventHandlersEventMap[T_5]["detail"]> extends GlobalEventHandlersEventMap[T_5]["detail"] ? CustomEventInit<GlobalEventHandlersEventMap[T_5]["detail"]> : CustomEventInit<GlobalEventHandlersEventMap[T_5]["detail"]> & {
                detail: GlobalEventHandlersEventMap[T_5]["detail"];
            } : CustomEventInit<any> : CustomEventInit<any>): T_5 extends keyof GlobalEventHandlersEventMap ? GlobalEventHandlersEventMap[T_5] extends CustomEvent<unknown> ? GlobalEventHandlersEventMap[T_5] : CustomEvent<unknown> : CustomEvent<unknown>;
        };
        disabled: boolean;
        readonly: boolean;
        max: number;
        rating: HTMLElement;
        precision: number;
        getSymbol: (value: number) => string;
        handleHoverValueChange: () => void;
        handleIsHoveringChange: () => void;
    } & {
        onSlChange: (e: SlChangeEvent) => void;
        onSlHover: (e: SlHoverEvent) => void;
    }> & React.RefAttributes<Component>>;
}
export default SlComponent;
