'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});
var _slice = Array.prototype.slice;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _ajax = require('../ajax');

var _ajax2 = _interopRequireDefault(_ajax);

var _metalCoreObject = require('../metal/core-object');

var _metalCoreObject2 = _interopRequireDefault(_metalCoreObject);

var ListingsAdapter = _metalCoreObject2['default'].extend(Object.defineProperties({
  ajax: _ajax2['default'],

  constructor: function constructor(config) {
    this.config = config;
  },

  pathForType: function pathForType(type) {
    return '/' + type.slice(0, -1) + '_listings';
  },

  buildUrl: function buildUrl(singleOrMultiple, type, idOrQuery) {
    switch (singleOrMultiple) {
      case 'multiple':
        return this.buildMultipleUrl(type, idOrQuery);
      case 'single':
        return this.buildSingleUrl(type, idOrQuery);
      default:
        return '';
    }
  },

  buildMultipleUrl: function buildMultipleUrl(type) {
    var query = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];

    var url = '' + this.baseUrl + this.pathForType(type);
    var paramNames = Object.keys(query);

    if (paramNames.length > 0) {
      var queryString = paramNames.map(function (key) {
        var value = undefined;

        if (Array.isArray(query[key])) {
          value = query[key].join(',');
        } else {
          value = query[key];
        }

        return key + '=' + encodeURIComponent(value);
      }).join('&');

      return url + '?' + queryString;
    }

    return url;
  },

  buildSingleUrl: function buildSingleUrl(type, id) {
    return '' + this.baseUrl + this.pathForType(type) + '/' + id;
  },

  fetchMultiple: function fetchMultiple() /* type, [query] */{
    var url = this.buildUrl.apply(this, ['multiple'].concat(_slice.call(arguments)));

    return this.ajax('GET', url, { headers: this.headers }).then(function (response) {
      return response.json;
    });
  },

  fetchSingle: function fetchSingle() /* type, id */{
    var url = this.buildUrl.apply(this, ['single'].concat(_slice.call(arguments)));

    return this.ajax('GET', url, { headers: this.headers }).then(function (response) {
      return response.json;
    });
  }
}, {
  base64ApiKey: {
    get: function get() {
      return btoa(this.config.apiKey);
    },
    configurable: true,
    enumerable: true
  },
  baseUrl: {
    get: function get() {
      var _config = this.config;
      var myShopifyDomain = _config.myShopifyDomain;
      var appId = _config.appId;

      return 'https://' + myShopifyDomain + '.myshopify.com/api/apps/' + appId;
    },
    configurable: true,
    enumerable: true
  },
  headers: {
    get: function get() {
      return {
        Authorization: 'Basic ' + this.base64ApiKey,
        'Content-Type': 'application/json'
      };
    },
    configurable: true,
    enumerable: true
  }
}));

exports['default'] = ListingsAdapter;
module.exports = exports['default'];