'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});
function authToUrl(url, opts) {
  var authorization = undefined;

  if (opts.headers) {
    Object.keys(opts.headers).forEach(function (key) {
      if (key.toLowerCase() === 'authorization') {
        authorization = opts.headers[key];
      }
    });
  }

  if (authorization) {
    var hashedKey = authorization.split(' ').slice(-1)[0];

    try {
      var plainKey = atob(hashedKey);

      var newUrl = undefined;

      if (url.indexOf('?') > -1) {
        newUrl = url + '&_x_http_authorization=' + plainKey;
      } else {
        newUrl = url + '?_x_http_authorization=' + plainKey;
      }

      return newUrl;
    } catch (e) {
      // atob choked on non-encoded data. Therefore, not a form of auth we
      // support.
      //
      // NOOP
      //
    }
  }

  /* eslint newline-before-return: 0 */
  return url;
}

function ie9Ajax(method, url, opts) {
  return new Promise(function (resolve, reject) {
    var xdr = new XDomainRequest();

    xdr.onload = function () {
      try {
        var json = JSON.parse(xdr.responseText);

        resolve({ json: json, originalResponse: xdr, isJSON: true });
      } catch (e) {
        resolve({ text: xdr.responseText, originalResponse: xdr, isText: true });
      }
    };

    function handleError() {
      reject(new Error('There was an error with the XDR'));
    }

    xdr.onerror = handleError;
    xdr.ontimeout = handleError;

    xdr.open(method, authToUrl(url, opts));
    xdr.send(opts.data);
  });
}

exports['default'] = ie9Ajax;
module.exports = exports['default'];