/* eslint no-undefined: 0 */

'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});
var assign = undefined;

if (typeof Object.assign === 'function') {
  assign = Object.assign;
} else {
  assign = function (target) {
    if (target === undefined || target === null) {
      throw new TypeError('Cannot convert undefined or null to object');
    }

    var output = Object(target);

    var propertyObjects = [].slice.call(arguments, 1);

    if (propertyObjects.length > 0) {
      propertyObjects.forEach(function (source) {
        if (source !== undefined && source !== null) {
          var nextKey = undefined;

          for (nextKey in source) {
            if (source.hasOwnProperty(nextKey)) {
              output[nextKey] = source[nextKey];
            }
          }
        }
      });
    }

    return output;
  };
}

exports['default'] = assign;
module.exports = exports['default'];