'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _assign = require('./assign');

var _assign2 = _interopRequireDefault(_assign);

var _includes = require('./includes');

var _includes2 = _interopRequireDefault(_includes);

function wrap(func, superFunc) {
  function superWrapper() {
    var originalSuper = this['super'];

    this['super'] = function () {
      return superFunc.apply(this, arguments);
    };

    var ret = func.apply(this, arguments);

    this['super'] = originalSuper;

    return ret;
  }

  superWrapper.wrappedFunction = func;

  return superWrapper;
}

function defineProperties(names, proto, destination) {
  var parentProto = Object.getPrototypeOf(destination);

  names.forEach(function (name) {
    var descriptor = Object.getOwnPropertyDescriptor(proto, name);
    var parentDescriptor = parentProto.hasOwnProperty(name) && Object.getOwnPropertyDescriptor(parentProto, name);

    if (typeof parentDescriptor.value === 'function' && typeof descriptor.value === 'function') {
      var wrappedFunction = wrap(descriptor.value, parentDescriptor.value);

      Object.defineProperty(destination, name, { value: wrappedFunction });
    } else {
      Object.defineProperty(destination, name, descriptor);
    }
  });
}

function createClass(props) {
  var parent = arguments.length <= 1 || arguments[1] === undefined ? Object : arguments[1];

  var Constructor = wrap(props.constructor, parent);
  var instancePropertyNames = Object.getOwnPropertyNames(props).filter(function (key) {
    return !(0, _includes2['default'])(['constructor', 'static'], key);
  });

  (0, _assign2['default'])(Constructor, parent);

  Constructor.prototype = Object.create(parent.prototype);
  defineProperties(instancePropertyNames, props, Constructor.prototype);
  Constructor.prototype.constructor = Constructor;

  var staticProps = props['static'];

  if (staticProps) {
    var staticPropertyNames = Object.getOwnPropertyNames(staticProps);

    defineProperties(staticPropertyNames, staticProps, Constructor);
  }

  return Constructor;
}

exports['default'] = createClass;
module.exports = exports['default'];