'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _baseModel = require('./base-model');

var _baseModel2 = _interopRequireDefault(_baseModel);

var _productOptionModel = require('./product-option-model');

var _productOptionModel2 = _interopRequireDefault(_productOptionModel);

var _productVariantModel = require('./product-variant-model');

var _productVariantModel2 = _interopRequireDefault(_productVariantModel);

var _metalUniq = require('../metal/uniq');

var _metalUniq2 = _interopRequireDefault(_metalUniq);

/**
   * Class for products returned by fetch('product')
   * @class ProductModel
   * @constructor
 */
var ProductModel = _baseModel2['default'].extend(Object.defineProperties({
  constructor: function constructor() {
    this['super'].apply(this, arguments);
  }

}, {
  id: { /**
          * Product unique ID
          * @property id
          * @type {String}
        */

    get: function get() {
      return this.attrs.product_id;
    },
    configurable: true,
    enumerable: true
  },
  title: {

    /**
      * Product title
      * @property title
      * @type {String}
    */

    get: function get() {
      return this.attrs.title;
    },
    configurable: true,
    enumerable: true
  },
  images: {

    /**
      * All images associated with product.
      * @property images
      * @type {Array} array of image objects.
    */

    get: function get() {
      return this.attrs.images;
    },
    configurable: true,
    enumerable: true
  },
  memoized: {
    get: function get() {
      this._memoized = this._memoized || {};

      return this._memoized;
    },
    configurable: true,
    enumerable: true
  },
  options: {

    /**
       *  Get array of options with nested values. Useful for creating UI for selecting options.
       *
       * ```javascript
       *  var elements = product.options.map(function(option) {
       *    return '<select name="' + option.name + '">' + option.values.map(function(value) {
       *      return '<option value="' + value + '">' + value + '</option>';
       *    }) + '</select>';
       *  });
       * ```
       *
       * @attribute options
       * @type {Array|Option}
     */

    get: function get() {
      if (this.memoized.options) {
        return this.memoized.options;
      }

      var baseOptions = this.attrs.options;
      var variants = this.variants;

      this.memoized.options = baseOptions.map(function (option) {
        var name = option.name;

        var dupedValues = variants.reduce(function (valueList, variant) {
          var optionValueForOption = variant.optionValues.filter(function (optionValue) {
            return optionValue.name === option.name;
          })[0];

          valueList.push(optionValueForOption.value);

          return valueList;
        }, []);

        var values = (0, _metalUniq2['default'])(dupedValues);

        return new _productOptionModel2['default']({ name: name, values: values });
      });

      return this.memoized.options;
    },
    configurable: true,
    enumerable: true
  },
  variants: {

    /**
      * All variants of a product.
      * @property variants
      * @type {Array|ProductVariantModel} array of ProductVariantModel instances.
    */

    get: function get() {
      var _this = this;

      return this.attrs.variants.map(function (variant) {
        return new _productVariantModel2['default']({ variant: variant, product: _this }, { config: _this.config });
      });
    },
    configurable: true,
    enumerable: true
  },
  selections: {

    /**
      * Retrieve currently selected option values.
      * @attribute selections
      * @type {Option}
    */

    get: function get() {
      return this.options.map(function (option) {
        return option.selected;
      });
    },
    configurable: true,
    enumerable: true
  },
  selectedVariant: {

    /**
      * Retrieve variant for currently selected options
      * @attribute selectedVariant
      * @type {Object}
    */

    get: function get() {
      var variantTitle = this.selections.join(' / ');

      return this.variants.filter(function (variant) {
        return variant.title === variantTitle;
      })[0];
    },
    configurable: true,
    enumerable: true
  },
  selectedVariantImage: {

    /**
      * Retrieve image for currently selected variantImage
      * @attribute selectedVariantImage
      * @type {Object}
    */

    get: function get() {
      return this.selectedVariant.image;
    },
    configurable: true,
    enumerable: true
  }
}));

exports['default'] = ProductModel;
module.exports = exports['default'];