'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _baseModel = require('./base-model');

var _baseModel2 = _interopRequireDefault(_baseModel);

var _metalIncludes = require('../metal/includes');

var _metalIncludes2 = _interopRequireDefault(_metalIncludes);

/**
  * Class for product option
  * @class Option
  * @constructor
*/
var ProductOptionModel = _baseModel2['default'].extend(Object.defineProperties({
  constructor: function constructor() {
    this['super'].apply(this, arguments);

    this.selected = this.values[0];
  }

}, {
  name: { /**
            * name of option (ex. "Size", "Color")
            * @property name
            * @type String
          */

    get: function get() {
      return this.attrs.name;
    },
    configurable: true,
    enumerable: true
  },
  values: {

    /**
      * possible values for selection
      * @property values
      * @type Array
    */

    get: function get() {
      return this.attrs.values;
    },
    configurable: true,
    enumerable: true
  },
  selected: {

    /**
      * get/set selected option value (ex. "Large"). Setting this will update the
      * selected value on the model. Throws {Error} if setting selected to value that does not exist for option
      * @property selected
      * @type String
    */

    get: function get() {
      return this._selected;
    },
    set: function set(value) {
      if ((0, _metalIncludes2['default'])(this.values, value)) {
        this._selected = value;
      } else {
        throw new Error('Invalid option selection for ' + this.name + '.');
      }

      return value;
    },
    configurable: true,
    enumerable: true
  }
}));

exports['default'] = ProductOptionModel;
module.exports = exports['default'];