'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _baseModel = require('./base-model');

var _baseModel2 = _interopRequireDefault(_baseModel);

/**
  * Model for product variant
  * @class ProductVariantModel
  * @constructor
*/
var ProductVariantModel = _baseModel2['default'].extend(Object.defineProperties({
  constructor: function constructor() {
    this['super'].apply(this, arguments);
  },

  /**
    * Checkout URL for purchasing variant with quantity.
    * @method checkoutUrl
    * @param {Number} [quantity = 1] quantity of variant
    * @public
    * @return {String} Checkout URL
  */
  checkoutUrl: function checkoutUrl() {
    var quantity = arguments.length <= 0 || arguments[0] === undefined ? 1 : arguments[0];

    var config = this.config;
    var baseUrl = 'https://' + config.myShopifyDomain + '.myshopify.com/cart';

    var variantPath = this.id + ':' + parseInt(quantity, 10);

    var query = 'api_key=' + config.apiKey;

    return baseUrl + '/' + variantPath + '?' + query;
  }
}, {
  id: { /**
          * Variant unique ID
          * @property id
          * @type {String}
        */

    get: function get() {
      return this.attrs.variant.id;
    },
    configurable: true,
    enumerable: true
  },
  productId: {

    /**
      * ID of product variant belongs to
      * @property productId
      * @type {String}
    */

    get: function get() {
      return this.attrs.product.id;
    },
    configurable: true,
    enumerable: true
  },
  title: {

    /**
      * Title of variant
      * @property title
      * @type {String}
    */

    get: function get() {
      return this.attrs.variant.title;
    },
    configurable: true,
    enumerable: true
  },
  productTitle: {

    /**
      * Title of product variant belongs to
      * @property productTitle
      * @type {String}
    */

    get: function get() {
      return this.attrs.product.title;
    },
    configurable: true,
    enumerable: true
  },
  compareAtPrice: {

    /**
      * <a href="https://docs.shopify.com/manual/products/promoting-marketing/sales">
      * Compare at</a> price for variant formatted as currency.
      * @property compareAtPrice
      * @type {String}
    */

    get: function get() {
      return this.attrs.variant.compare_at_price;
    },
    configurable: true,
    enumerable: true
  },
  price: {

    /**
      * Price of variant, formatted as currency
      * @property price
      * @type {String}
    */

    get: function get() {
      return this.attrs.variant.price;
    },
    configurable: true,
    enumerable: true
  },
  grams: {

    /**
      * Variant weight in grams
      * @property grams
      * @type {Number}
    */

    get: function get() {
      return this.attrs.variant.grams;
    },
    configurable: true,
    enumerable: true
  },
  optionValues: {

    /**
      * Option values associated with this variant, ex {name: "color", value: "Blue"}
      * @property optionValues
      * @type {Array|Object}
    */

    get: function get() {
      return this.attrs.variant.option_values;
    },
    configurable: true,
    enumerable: true
  },
  image: {

    /**
      * Image for variant
      * @property image
      * @type {Object}
    */

    get: function get() {
      var id = this.id;
      var images = this.attrs.product.images;

      var primaryImage = images[0];
      var variantImage = images.filter(function (image) {
        return image.variant_ids.indexOf(id) !== -1;
      })[0];

      return variantImage || primaryImage;
    },
    configurable: true,
    enumerable: true
  }
}));

exports['default'] = ProductVariantModel;
module.exports = exports['default'];