'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _baseModel = require('./base-model');

var _baseModel2 = _interopRequireDefault(_baseModel);

var _metalSetGuidFor = require('../metal/set-guid-for');

var ReferenceModel = _baseModel2['default'].extend(Object.defineProperties({

  /**
    * Class for reference model
    * @class ReferenceModel
    * @constructor
  */
  constructor: function constructor(attrs) {
    if (Object.keys(attrs).indexOf('referenceId') < 0) {
      throw new Error('Missing key referenceId of reference. References to null are not allowed');
    }

    this['super'].apply(this, arguments);
  }

}, {
  id: { /**
          * get the ID for current reference (not what it refers to, but its own unique identifier)
          * @property id
          * @type {String}
        */

    get: function get() {
      return this.attrs[_metalSetGuidFor.GUID_KEY];
    },
    configurable: true,
    enumerable: true
  },
  referenceId: {
    get: function get() {
      return this.attrs.referenceId;
    },
    set: function set(value) {
      this.attrs.referenceId = value;

      return value;
    },
    configurable: true,
    enumerable: true
  }
}));

exports['default'] = ReferenceModel;
module.exports = exports['default'];