'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _metalCoreObject = require('../metal/core-object');

var _metalCoreObject2 = _interopRequireDefault(_metalCoreObject);

var _metalAssign = require('../metal/assign');

var _metalAssign2 = _interopRequireDefault(_metalAssign);

var _modelsCartModel = require('../models/cart-model');

var _modelsCartModel2 = _interopRequireDefault(_modelsCartModel);

var CartSerializer = _metalCoreObject2['default'].extend({
  constructor: function constructor(config) {
    this.config = config;
  },

  rootKeyForType: function rootKeyForType(type) {
    return type.slice(0, -1);
  },

  modelForType: function modelForType() /* type */{
    return _modelsCartModel2['default'];
  },

  deserializeSingle: function deserializeSingle(type) {
    var singlePayload = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];
    var metaAttrs = arguments.length <= 2 || arguments[2] === undefined ? {} : arguments[2];

    var modelAttrs = singlePayload[this.rootKeyForType(type)];
    var model = this.modelFromAttrs(type, modelAttrs, metaAttrs);

    return model;
  },

  modelFromAttrs: function modelFromAttrs(type, attrs, metaAttrs) {
    var Model = this.modelForType(type);

    metaAttrs.config = this.config;

    return new Model(attrs, metaAttrs);
  },

  serialize: function serialize(type, model) {
    var root = this.rootKeyForType(type);
    var payload = {};
    var attrs = (0, _metalAssign2['default'])({}, model.attrs);

    payload[root] = attrs;

    delete attrs.attributes;

    Object.keys(attrs).forEach(function (key) {
      var value = attrs[key];

      if (value === null || typeof value === 'string' && value.length === 0) {
        delete attrs[key];
      }
    });

    return payload;
  }
});

exports['default'] = CartSerializer;
module.exports = exports['default'];