'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _metalCoreObject = require('../metal/core-object');

var _metalCoreObject2 = _interopRequireDefault(_metalCoreObject);

var _modelsBaseModel = require('../models/base-model');

var _modelsBaseModel2 = _interopRequireDefault(_modelsBaseModel);

var _modelsProductModel = require('../models/product-model');

var _modelsProductModel2 = _interopRequireDefault(_modelsProductModel);

var ListingsSerializer = _metalCoreObject2['default'].extend({
  constructor: function constructor(config) {
    this.config = config;
  },

  rootKeyForType: function rootKeyForType(type) {
    return type.slice(0, -1) + '_listing';
  },

  models: {
    collections: _modelsBaseModel2['default'],
    products: _modelsProductModel2['default']
  },

  modelForType: function modelForType(type) {
    return this.models[type];
  },

  deserializeSingle: function deserializeSingle(type) {
    var singlePayload = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];
    var metaAttrs = arguments.length <= 2 || arguments[2] === undefined ? {} : arguments[2];

    var modelAttrs = singlePayload[this.rootKeyForType(type)];
    var model = this.modelFromAttrs(type, modelAttrs, metaAttrs);

    return model;
  },

  deserializeMultiple: function deserializeMultiple(type) {
    var _this = this;

    var collectionPayload = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];
    var metaAttrs = arguments.length <= 2 || arguments[2] === undefined ? {} : arguments[2];

    var models = collectionPayload[this.rootKeyForType(type) + 's'];

    return models.map(function (attrs) {
      var model = _this.modelFromAttrs(type, attrs, metaAttrs);

      return model;
    });
  },

  modelFromAttrs: function modelFromAttrs(type, attrs, metaAttrs) {
    var Model = this.modelForType(type);

    metaAttrs.config = this.config;

    return new Model(attrs, metaAttrs);
  }
});

exports['default'] = ListingsSerializer;
module.exports = exports['default'];