'use strict';

Object.defineProperty(exports, '__esModule', {
  value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _metalCoreObject = require('../metal/core-object');

var _metalCoreObject2 = _interopRequireDefault(_metalCoreObject);

var _metalAssign = require('../metal/assign');

var _metalAssign2 = _interopRequireDefault(_metalAssign);

var _modelsReferenceModel = require('../models/reference-model');

var _modelsReferenceModel2 = _interopRequireDefault(_modelsReferenceModel);

var ReferenceSerializer = _metalCoreObject2['default'].extend({
  constructor: function constructor(config) {
    this.config = config;
  },

  modelForType: function modelForType() /* type */{
    return _modelsReferenceModel2['default'];
  },

  deserializeSingle: function deserializeSingle(type) {
    var singlePayload = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];
    var metaAttrs = arguments.length <= 2 || arguments[2] === undefined ? {} : arguments[2];

    var Model = this.modelForType(type);

    return new Model(singlePayload, metaAttrs);
  },

  serialize: function serialize(type, model) {
    var attrs = (0, _metalAssign2['default'])({}, model.attrs);

    return attrs;
  }
});

exports['default'] = ReferenceSerializer;
module.exports = exports['default'];