require 'bundler/inline'

gemfile(true) do
  source 'https://rubygems.org'
  gem 'octokit', '~> 4.1.0'
end

CHANGELOG_PATH = 'CHANGELOG.md'

def get_releases
  Octokit.releases('Shopify/js-buy-sdk', per_page: 100)
end

def latest_changelog_release(changelog)
  changelog.find { |line| line =~ /###\s(\d+\.\d+\.\d+[^\s]*)/ }
  $1
end

def release_changelog_entry(release)
  release_date = release.published_at.strftime('%B %-d, %Y')

  release_lines = release.body.lines
  release_lines[0] = "### #{release.tag_name} (#{release_date})"
  release_lines.push('')

  release_lines.map do |line|
    line.encode(line.encoding, universal_newline: true)
  end
end

def releases_not_in_changelog(changelog, releases)
  releases.select do |release|
    release_version = Gem::Version.new(release.tag_name.gsub(/^v/, ''))
    changelog_release_version = Gem::Version.new(latest_changelog_release(changelog))

    release_version > changelog_release_version
  end
end

changelog = File.readlines(CHANGELOG_PATH)
releases = get_releases
releases_to_add = releases_not_in_changelog(changelog, releases)

new_releases = releases_to_add.map do |release|
  release_changelog_entry(release)
end

updated_changelog_text = changelog.insert(2, new_releases)

File.open(CHANGELOG_PATH, 'w+') do |f|
  f.puts(updated_changelog_text)
end
