'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
/* eslint no-undefined: 0 */

var assign = void 0;

if (typeof Object.assign === 'function') {
  assign = Object.assign;
} else {
  assign = function assign(target) {
    if (target === undefined || target === null) {
      throw new TypeError('Cannot convert undefined or null to object');
    }

    var output = Object(target);

    var propertyObjects = [].slice.call(arguments, 1);

    if (propertyObjects.length > 0) {
      propertyObjects.forEach(function (source) {
        if (source !== undefined && source !== null) {
          var nextKey = void 0;

          for (nextKey in source) {
            if (source.hasOwnProperty(nextKey)) {
              output[nextKey] = source[nextKey];
            }
          }
        }
      });
    }

    return output;
  };
}

exports.default = assign;