'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol ? "symbol" : typeof obj; };

/* eslint no-undefined: 0 complexity: 0 */

var GUID_KEY = 'shopify-buy-uuid';

var GUID_PREFIX = 'shopify-buy.' + Date.now();

var GUID_DESC = {
  writable: true,
  configurable: true,
  enumerable: true,
  value: null
};

var uuidSeed = 0;

function uuid() {
  return ++uuidSeed;
}

var numberCache = {};
var stringCache = {};

function setGuidFor(obj) {
  if (obj && obj[GUID_KEY]) {
    return obj[GUID_KEY];
  }

  if (obj === undefined) {
    return '(undefined)';
  }

  if (obj === null) {
    return '(null)';
  }

  var type = typeof obj === 'undefined' ? 'undefined' : _typeof(obj);
  var id = void 0;

  switch (type) {
    case 'number':
      id = numberCache[obj];

      if (!id) {
        id = numberCache[obj] = 'nu' + obj;
      }

      break;

    case 'string':
      id = stringCache[obj];

      if (!id) {
        id = numberCache[obj] = 'st' + uuid();
      }

      break;

    case 'boolean':
      if (obj) {
        id = '(true)';
      } else {
        id = '(false)';
      }

      break;

    default:
      if (obj === Object) {
        id = '(Object)';
        break;
      }

      if (obj === Array) {
        id = '(Array)';
        break;
      }

      id = GUID_PREFIX + '.' + uuid();

      if (obj[GUID_KEY] === null) {
        obj[GUID_KEY] = id;
      } else {
        GUID_DESC.value = id;
        Object.defineProperty(obj, GUID_KEY, GUID_DESC);
      }
  }

  return id;
}

exports.default = setGuidFor;
exports.GUID_KEY = GUID_KEY;