'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _coreObject = require('../metal/core-object');

var _coreObject2 = _interopRequireDefault(_coreObject);

var _assign = require('../metal/assign');

var _assign2 = _interopRequireDefault(_assign);

var _cartModel = require('../models/cart-model');

var _cartModel2 = _interopRequireDefault(_cartModel);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var CartSerializer = _coreObject2.default.extend({
  constructor: function constructor(config) {
    this.config = config;
  },
  rootKeyForType: function rootKeyForType(type) {
    return type.slice(0, -1);
  },
  modelForType: function modelForType() /* type */{
    return _cartModel2.default;
  },
  deserializeSingle: function deserializeSingle(type) {
    var singlePayload = arguments.length <= 1 || arguments[1] === undefined ? {} : arguments[1];
    var metaAttrs = arguments.length <= 2 || arguments[2] === undefined ? {} : arguments[2];

    var modelAttrs = singlePayload[this.rootKeyForType(type)];
    var model = this.modelFromAttrs(type, modelAttrs, metaAttrs);

    return model;
  },
  modelFromAttrs: function modelFromAttrs(type, attrs, metaAttrs) {
    var Model = this.modelForType(type);

    metaAttrs.config = this.config;

    return new Model(attrs, metaAttrs);
  },
  serialize: function serialize(type, model) {
    var root = this.rootKeyForType(type);
    var payload = {};
    var attrs = (0, _assign2.default)({}, model.attrs);

    payload[root] = attrs;

    delete attrs.attributes;

    Object.keys(attrs).forEach(function (key) {
      var value = attrs[key];

      if (value === null || typeof value === 'string' && value.length === 0) {
        delete attrs[key];
      }
    });

    return payload;
  }
});

exports.default = CartSerializer;