export declare enum Weekdays {
    Sunday = 0,
    Monday = 1,
    Tuesday = 2,
    Wednesday = 3,
    Thursday = 4,
    Friday = 5,
    Saturday = 6,
}
export declare enum Months {
    January = 0,
    February = 1,
    March = 2,
    April = 3,
    May = 4,
    June = 5,
    July = 6,
    August = 7,
    September = 8,
    October = 9,
    November = 10,
    December = 11,
}
export declare enum TimeUnit {
    Second = 1000,
    Minute = 60000,
    Hour = 3600000,
    Day = 86400000,
    Week = 604800000,
    Year = 31536000000,
}
export interface Range {
    start: Date;
    end: Date;
}
export declare type Year = number;
export declare function getYearForRange({start, end}: Range): number;
export declare function getMonthForRange({start, end}: Range): Months;
export declare function abbreviationForWeekday(weekday: Weekdays): string;
export declare type Week = (Date | null)[];
export declare function getWeeksForMonth(month: Months, year: Year, weekStartsOn?: Weekdays): Week[];
export declare function dateIsInRange(day: Date | null, range: Range): boolean;
export declare function dateIsSelected(day: Date | null, range: Range): boolean;
export declare function isSameDay(day1: Date, day2: Date): boolean;
export declare function getDateDiff(resolution: TimeUnit, date: Date, today?: Date): number;
export declare function getNewRange(range: Range | undefined, selected: Date): Range;
export declare function getNextDisplayMonth(month: Months): Months;
export declare function getNextDisplayYear(month: Months, year: Year): Year;
export declare function getPreviousDisplayMonth(month: Months): Months;
export declare function getPreviousDisplayYear(month: Months, year: Year): Year;
export declare function isDateAfter(date: Date, dateToCompare: Date): boolean;
export declare function isDateBefore(date: Date, dateToCompare: Date): boolean;
export declare function isLessThanOneMinuteAgo(date: Date, today?: Date): boolean;
export declare function isLessThanOneHourAgo(date: Date, today?: Date): boolean;
export declare function isLessThanOneDayAgo(date: Date, today?: Date): boolean;
export declare function isLessThanOneWeekAgo(date: Date, today?: Date): boolean;
export declare function isLessThanOneYearAgo(date: Date, today?: Date): boolean;
export declare function isSameMonthAndYear(source: Date, target: Date): boolean;
export declare function isSameDate(source: Date, target: Date): boolean;
export declare function isToday(date: Date): boolean;
export declare function isYesterday(date: Date): boolean;
