"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var url_1 = require("url");
function getPath(urlParam) {
    // No window, or we are running in JSDOM for tests
    if (typeof window === 'undefined' || window.navigator.userAgent.indexOf('Node.js') >= 0) {
        var path = url_1.default.parse(urlParam).pathname;
        return path ? path : '/';
    }
    return browserGetPath(urlParam);
}
exports.getPath = getPath;
var link;
function browserGetPath(urlParam) {
    if (!link) {
        link = document.createElement('a');
    }
    link.href = urlParam;
    var path = link.pathname;
    if (path[0] !== '/') {
        path = "/" + path;
    }
    return path;
}
