import * as React from 'react';
import { Section } from './components';
import styles from './ActionList.scss';
export default function ActionList({ items, sections = [], actionRole, onActionAnyItem, }) {
    let finalSections = [];
    if (items) {
        finalSections = [{ items }, ...sections];
    }
    else if (sections) {
        finalSections = sections;
    }
    const hasMultipleSections = finalSections.length > 1;
    const Element = hasMultipleSections ? 'ul' : 'div';
    const sectionMarkup = finalSections.map((section, index) => {
        return (<Section key={section.title || index} section={section} onActionAnyItem={onActionAnyItem} hasMultipleSections={hasMultipleSections} actionRole={actionRole}/>);
    });
    return <Element className={styles.ActionList}>{sectionMarkup}</Element>;
}
