import * as tslib_1 from "tslib";
import * as React from 'react';
import ThemeProvider from '../ThemeProvider';
import { StickyManager, ScrollLockManager, createAppProviderContext, } from './utilities';
import { polarisAppProviderContextTypes, } from './types';
export default class AppProvider extends React.Component {
    constructor(props) {
        super(props);
        this.subscriptions = [];
        this.subscribe = (callback) => {
            this.subscriptions.push(callback);
        };
        this.unsubscribe = (callback) => {
            this.subscriptions = this.subscriptions.filter((subscription) => subscription !== callback);
        };
        this.stickyManager = new StickyManager();
        this.scrollLockManager = new ScrollLockManager();
        const _a = this.props, { theme, children } = _a, rest = tslib_1.__rest(_a, ["theme", "children"]);
        this.polarisContext = createAppProviderContext(Object.assign({}, rest, { stickyManager: this.stickyManager, scrollLockManager: this.scrollLockManager, subscribe: this.subscribe, unsubscribe: this.unsubscribe }));
    }
    componentDidMount() {
        if (document != null) {
            this.stickyManager.setContainer(document);
        }
    }
    componentWillReceiveProps({ i18n, linkComponent, apiKey, shopOrigin, forceRedirect, }) {
        if (i18n !== this.props.i18n ||
            linkComponent !== this.props.linkComponent ||
            apiKey !== this.props.apiKey ||
            shopOrigin !== this.props.shopOrigin ||
            forceRedirect !== this.props.forceRedirect) {
            const stickyManager = this.stickyManager;
            this.polarisContext = createAppProviderContext({
                i18n,
                linkComponent,
                apiKey,
                shopOrigin,
                forceRedirect,
                stickyManager,
                subscribe: this.subscribe,
                unsubscribe: this.unsubscribe,
            });
        }
        this.subscriptions.forEach((subscriberCallback) => subscriberCallback());
    }
    getChildContext() {
        return this.polarisContext;
    }
    render() {
        const { theme = { logo: null } } = this.props;
        return (<ThemeProvider theme={theme}>
        {React.Children.only(this.props.children)}
      </ThemeProvider>);
    }
}
AppProvider.childContextTypes = polarisAppProviderContextTypes;
