import { get } from '../../../../utilities/get';
import defaultTranslation from '../../../../locales';
import merge from '../../../../utilities/merge';
import translate from './translate';
export default class Intl {
    constructor(translation) {
        this.translation = translation;
        this.translate = (id, replacements) => {
            return translate(id, this.translation, replacements);
        };
        this.setTranslation(translation);
    }
    setTranslation(translation) {
        const i18n = Array.isArray(translation)
            ? merge(...translation)
            : translation;
        this.translation = i18n
            ? merge(defaultTranslation, i18n)
            : defaultTranslation;
    }
    translationKeyExists(path) {
        return Boolean(get(this.translation, path));
    }
}
