import { noop } from '@shopify/javascript-utilities/other';
import createApp, { getShopOrigin, LifecycleHook, } from '@shopify/app-bridge';
import { StickyManager } from '../withSticky';
import ScrollLockManager from '../ScrollLockManager';
import Intl from '../Intl';
import Link from '../Link';
import { polarisVersion } from '../../../../configure';
export default function createAppProviderContext({ i18n, linkComponent, apiKey, shopOrigin, forceRedirect, stickyManager, scrollLockManager, subscribe = noop, unsubscribe = noop, } = {}) {
    const intl = new Intl(i18n);
    const link = new Link(linkComponent);
    const appBridge = apiKey
        ? createApp({
            apiKey,
            shopOrigin: shopOrigin || getShopOrigin(),
            forceRedirect,
        })
        : undefined;
    if (appBridge && appBridge.hooks) {
        appBridge.hooks.set(LifecycleHook.DispatchAction, setClientInterfaceHook);
    }
    return {
        polaris: {
            intl,
            link,
            stickyManager: stickyManager || new StickyManager(),
            scrollLockManager: scrollLockManager || new ScrollLockManager(),
            subscribe,
            unsubscribe,
            appBridge,
        },
    };
}
export const setClientInterfaceHook = function (next) {
    return function (action) {
        action.clientInterface = {
            name: '@shopify/polaris',
            version: polarisVersion,
        };
        return next(action);
    };
};
