import { createThemeContext, } from '../../../ThemeProvider';
import createAppProviderContext from '../createAppProviderContext';
export default function createPolarisContext(contextOne, contextTwo) {
    let appProviderContext;
    let themeContext;
    if (contextOne && 'logo' in contextOne) {
        themeContext = contextOne;
        appProviderContext = contextTwo;
    }
    else {
        appProviderContext = contextOne;
        themeContext = contextTwo;
    }
    const appProvider = appProviderContext
        ? createAppProviderContext(appProviderContext)
        : createAppProviderContext();
    const theme = themeContext
        ? createThemeContext(themeContext)
        : createThemeContext();
    return Object.assign({}, appProvider, theme);
}
