import * as React from 'react';
import hoistStatics from 'hoist-non-react-statics';
import merge from '../../../../utilities/merge';
import { polarisAppProviderContextTypes } from '../../types';
export default function withAppProvider() {
    return function addProvider(WrappedComponent) {
        class WithProvider extends React.Component {
            constructor() {
                super(...arguments);
                this.handleContextUpdate = () => {
                    this.forceUpdate();
                };
            }
            componentDidMount() {
                const { polaris: { subscribe: subscribeToPolaris }, polarisTheme: { subscribe: subscribeToTheme }, } = this.context;
                if (subscribeToPolaris) {
                    subscribeToPolaris(this.handleContextUpdate);
                }
                if (subscribeToTheme) {
                    subscribeToTheme(this.handleContextUpdate);
                }
            }
            componentWillUnmount() {
                const { polaris: { unsubscribe: unsubscribeToPolaris }, polarisTheme: { unsubscribe: unsubscribeToTheme }, } = this.context;
                if (unsubscribeToPolaris) {
                    unsubscribeToPolaris(this.handleContextUpdate);
                }
                if (unsubscribeToTheme) {
                    unsubscribeToTheme(this.handleContextUpdate);
                }
            }
            render() {
                const { polaris, polarisTheme } = this.context;
                const polarisContext = Object.assign({}, polaris, { theme: polarisTheme });
                if (!polaris) {
                    throw new Error(`The <AppProvider> component is required as of v2.0 of Polaris React. See
            https://polaris.shopify.com/components/structure/app-provider for implementation
            instructions.`);
                }
                return <WrappedComponent {...this.props} polaris={polarisContext}/>;
            }
        }
        WithProvider.contextTypes = WrappedComponent.contextTypes
            ? merge(WrappedComponent.contextTypes, polarisAppProviderContextTypes)
            : polarisAppProviderContextTypes;
        const FinalComponent = hoistStatics(WithProvider, WrappedComponent);
        return FinalComponent;
    };
}
