import * as React from 'react';
import hoistStatics from 'hoist-non-react-statics';
import merge from '../../../../utilities/merge';
import { polarisAppProviderContextTypes } from '../../types';
import StickyManager from './StickyManager';
export default function withSticky() {
    return function addStickyManager(WrappedComponent) {
        // eslint-disable-next-line shopify/react-initialize-state
        class WithStickyManager extends React.Component {
            constructor(props, context) {
                super(props);
                this.stickyManager = new StickyManager();
                const { polaris } = context;
                this.polarisContext = Object.assign({}, polaris, { stickyManager: this.stickyManager });
            }
            getChildContext() {
                return {
                    polaris: this.polarisContext,
                };
            }
            render() {
                return (<WrappedComponent {...this.props} polaris={this.polarisContext}/>);
            }
        }
        WithStickyManager.childContextTypes = polarisAppProviderContextTypes;
        WithStickyManager.contextTypes = WrappedComponent.contextTypes
            ? merge(WrappedComponent.contextTypes, polarisAppProviderContextTypes)
            : polarisAppProviderContextTypes;
        const FinalComponent = hoistStatics(WithStickyManager, WrappedComponent);
        return FinalComponent;
    };
}
