import * as React from 'react';
import { withAppProvider } from '../AppProvider';
import Spinner from '../Spinner';
import { ComboBox } from './components';
import styles from './Autocomplete.scss';
function TextField(props) {
    return <ComboBox.TextField {...props}/>;
}
export class Autocomplete extends React.PureComponent {
    render() {
        const { id, options, selected, textField, preferredPosition, listTitle, allowMultiple, loading, actionBefore, willLoadMoreResults, emptyState, onSelect, onLoadMoreResults, polaris: { intl }, } = this.props;
        const spinnerMarkup = loading ? (<div className={styles.Loading}>
        <Spinner size="small" accessibilityLabel={intl.translate('Polaris.Autocomplete.spinnerAccessibilityLabel')}/>
      </div>) : null;
        const conditionalOptions = loading && !willLoadMoreResults ? [] : options;
        const conditionalAction = actionBefore && actionBefore !== [] ? [actionBefore] : undefined;
        return (<ComboBox id={id} options={conditionalOptions} selected={selected} textField={textField} preferredPosition={preferredPosition} listTitle={listTitle} allowMultiple={allowMultiple} contentAfter={spinnerMarkup} actionsBefore={conditionalAction} onSelect={onSelect} onEndReached={onLoadMoreResults} emptyState={emptyState}/>);
    }
}
Autocomplete.TextField = TextField;
Autocomplete.ComboBox = ComboBox;
export default withAppProvider()(Autocomplete);
