import * as React from 'react';
import { contextTypes } from '../../../types';
import BaseTextField from '../../../../../TextField';
export default class TextField extends React.PureComponent {
    constructor() {
        super(...arguments);
        this.handleContextUpdate = () => {
            this.forceUpdate();
        };
    }
    componentDidMount() {
        const { subscribe } = this.context;
        subscribe(this.handleContextUpdate);
    }
    render() {
        const { selectedOptionId, comboBoxId } = this.context;
        return (<BaseTextField {...this.props} autoComplete={false} ariaAutocomplete="list" ariaActiveDescendant={selectedOptionId} ariaControls={comboBoxId}/>);
    }
}
TextField.contextTypes = contextTypes;
