import * as React from 'react';
import { classNames } from '@shopify/react-utilities';
import ScrollLock from '../ScrollLock';
import styles from './Backdrop.scss';
export default function Backdrop(props) {
    const { onClick, onTouchStart, belowNavigation } = props;
    const className = classNames(styles.Backdrop, belowNavigation && styles.belowNavigation);
    return (<React.Fragment>
      <ScrollLock />
      <div className={className} onClick={onClick} testID="Backdrop" onTouchStart={onTouchStart}/>
    </React.Fragment>);
}
